// LISTING 14.3. Tworzenie Issue link

import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.component.ComponentAccessor;

// 1. Pobranie obiektów typu interfejsowego Issue.

// Zgłoszenie typu Story.
def issueStory = ComponentAccessor.getIssueManager().getIssueObject("TL-2");

// Zgłoszenia typu Bug.
def issueBug4 = ComponentAccessor.getIssueManager().getIssueObject("TL-7");
def issueBug5 = ComponentAccessor.getIssueManager().getIssueObject("TL-8");
def issueBug6 = ComponentAccessor.getIssueManager().getIssueObject("TL-9");
def issueBug7 = ComponentAccessor.getIssueManager().getIssueObject("TL-10");

// 2. Pobranie obiektu użytkownika ze wszystkimi uprawnieniami do edycji zgłoszeń w projektach.
def permittedUser = ComponentAccessor.getUserManager().getUserByName("admin");

// 3. Pobranie menedżerów.
def issueLinkManager = ComponentAccessor.getIssueLinkManager();

// 4. Utworzenie linku typu Related, kierunek wychodzący z TL-2 do TL-7.
// Typ linku Related ==> id = 10003.
issueLinkManager.createIssueLink(issueStory.getId(), issueBug4.getId(), 10003, 1, permittedUser);

// 5. Utworzenie linku typu Related w TL-2, kierunek przychodzący z TL-8 do TL-2.
// Typ linku Related ==> id = '0003.
issueLinkManager.createIssueLink(issueBug5.getId(), issueStory.getId(), 10003, 1, permittedUser);

// 6. Utworzenie linku typu Blocks w TL-2, kierunek wychodzący z TL-2 do TL-9.
// Typ linku Blocks ==> id = 10000.
issueLinkManager.createIssueLink(issueStory.getId(), issueBug6.getId(), 10000, 1, permittedUser);

// 7. Utworzenie linku typu Blocks w TL-2, kierunek przychodzący z TL-10 do TL-2.
// Typ linku Blocks ==> id = 10000.
issueLinkManager.createIssueLink(issueBug7.getId(), issueStory.getId(), 10000, 1, permittedUser);