// LISTING 14.2. Aktualizacja danych w podlinkowanych zgłoszeniach

import com.atlassian.jira.issue.MutableIssue
import com.atlassian.jira.issue.link.IssueLink
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.type.EventDispatchOption

// 1. Pobranie obiektów typu interfejsowego Issue.
// Uwaga! W trakcie uruchamiania post funkcji zmienna issue ma automatycznie przypisany obiekt zgłoszenia.
def issueStory = issue;

// Opcja do ręcznego zdefiniowania obiektu zgłoszenia.
// def issueStory = ComponentAccessor.getIssueManager().getIssueObject("TL-1");

// 2. Pobranie użytkownika ze wszystkimi uprawnieniami do edycji zgłoszeń w projektach.
def permittedUser = ComponentAccessor.getUserManager().getUserByName("admin");

// 3. Pobranie menedżerów.
def issueLinkManager = ComponentAccessor.getIssueLinkManager();

// 4. Pobranie listy obiektów z linków przychodzących.
def List<IssueLink> storyInwardLinks = issueLinkManager.getInwardLinks(issueStory.getId());

// 5. Pobranie listy obiektów z linków wychodzących.
def List<IssueLink> storyOutwardLinks = issueLinkManager.getOutwardLinks(issueStory.getId());

// 6. Zmiana Assignee w zgłoszeniach zlinkowanych typem Related, będących w linkach przychodzących.
// Identyfikator typu Related to 10003.

// Wyszukanie powiązań typu Related w linkach przychodzących.
def issueToChangeAssigneeIn = storyInwardLinks.findAll() {
    storyInwardLink ->
        storyInwardLink.getLinkTypeId()==10003
};

// Zmiana Assignee w zlinkowanych zgłoszeniach.
issueToChangeAssigneeIn.each {
    issueLink ->

        // Pobranie zlinkowanego obiektu typu interfejsowego Issue do zmiany.
        MutableIssue issueToAssigne = issueLink.getSourceObject() as MutableIssue;

        // Pobranie obiektu Assignee ze zgłoszenia typu Story.
        def destinationAssignee = issueLink.getDestinationObject().getAssignee();

        // Przypisanie użytkownika do zlinkowanego zgłoszenia.
        issueToAssigne.setAssignee(destinationAssignee);
        ComponentAccessor.getIssueManager().updateIssue(permittedUser, issueToAssigne, EventDispatchOption.ISSUE_ASSIGNED, false);
};

// 7. Zmiana Assignee w zgłoszeniach powiązanych typem Related, będących w linkach wychodzących.
// Identyfikator typu Related to 10003.

// Wyszukanie powiązań typu Related w linkach wychodzących.
def issueToChangeAssigneeOut =storyOutwardLinks.findAll() {
    storyOutwardLink ->
        storyOutwardLink.getLinkTypeId()==10003;
};

// Zmiana Assigne w zgłoszeniach.
issueToChangeAssigneeOut.each {
    issueLink ->
        MutableIssue issueToAssigne = issueLink.getDestinationObject() as MutableIssue;
        def sourceAssignee = issueLink.getSourceObject().getAssignee();
        issueToAssigne.setAssignee(sourceAssignee);
        ComponentAccessor.getIssueManager().updateIssue(permittedUser, issueToAssigne, EventDispatchOption.ISSUE_ASSIGNED, false);
};

// 8. Dodanie komentarza we wszystkich zgłoszeniach z linków przychodzących.
storyInwardLinks.each {
    issueLink ->
        MutableIssue issueToComment = issueLink.getSourceObject() as MutableIssue;
        def destinationIssueKey = issueLink.getDestinationObject().getKey();
        ComponentAccessor.getCommentManager().create(issueToComment, permittedUser, "issue ${destinationIssueKey} has been updated", true);
};

// 9. Dodanie komentarza we wszystkich zgłoszeniach z linków wychodzących.
storyOutwardLinks.each {
    issueLink ->
        // Zabezpieczenie przed podwójnym dodaniem komentarza — zgłoszenia, które są zarówno w linkach przychodzących, jak i wychodzących.
        if (!storyInwardLinks.any() { storyInwardLink -> storyInwardLink.getSourceId()==issueLink.getDestinationId();}) {
            MutableIssue issueToComment = issueLink.getDestinationObject() as MutableIssue;
            def sourceIssueKey = issueLink.getSourceObject().getKey();
            ComponentAccessor.getCommentManager().create(issueToComment, permittedUser, "issue ${sourceIssueKey} has been updated", true);
        }
};