// LISTING 14.1. Pobranie zgłoszeń powiązanych (linked issues)

import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.component.ComponentAccessor;

// 1. Pobranie obiektu typu interfejsowego Issue ze zdefiniowanymi linkami.
def issueStory = ComponentAccessor.getIssueManager().getIssueObject("TL-1");

// 2. Pobranie menedżerów.
def issueLinkManager = ComponentAccessor.getIssueLinkManager();

// 3. Pobranie linków przychodzących ze zgłoszenia.
def List<IssueLink> storyInwardLinks = issueLinkManager.getInwardLinks(issueStory.getId());

// 4. Pobranie linków wychodzących ze zgłoszenia.
def List<IssueLink> storyOutwardLinks = issueLinkManager.getOutwardLinks(issueStory.getId());

// 5. Zestawienie danych z linków przychodzących w pętli.
String inwardLinksResult = "INWARDS: | ";
storyInwardLinks.each {
    storyInwardLink ->

        // Pobranie i wyświetlenie klucza obiektu typu interfejsowego Issue źródłowego zgłoszenia.
        inwardLinksResult += "sourceObjectKey: " + storyInwardLink.getSourceObject().getKey();

        // Pobranie i wyświetlenie klucza obiektu typu interfejsowego Issue docelowego zgłoszenia.
        inwardLinksResult += ", destinationObjectKey: " + storyInwardLink.getDestinationObject().getKey();

        // Pobranie i wyświetlenie nazwy typu linku.
        inwardLinksResult += ", linkType: " + storyInwardLink.getIssueLinkType().getName();
        inwardLinksResult += " | ";
};

// 6. Zestawienie danych z linków wychodzących w pętli.
String outwardLinksResult = "OUTWARDS: | ";
storyOutwardLinks.each {
    storyOutwardLink ->
   
        // Pobranie i wyświetlenie klucza obiektu typu interfejsowego Issue źródłowego zgłoszenia.
        outwardLinksResult += "sourceObjectKey: " + storyOutwardLink.getSourceObject().getKey();

        // Pobranie i wyświetlenie klucza obiektu typu interfejsowego Issue docelowego zgłoszenia.
        outwardLinksResult += ", destinationObjectKey: " + storyOutwardLink.getDestinationObject().getKey();

        // Pobranie i wyświetlenie nazwy typu linku.
        outwardLinksResult += ", linkType: " + storyOutwardLink.getIssueLinkType().getName(); 
        outwardLinksResult += " | ";
};

// 7. Zestawienie linków wychodzących i przychodzących metodą collect().

// Pobranie linków przychodzących ze zgłoszenia.
List<String> storyInwardLinksResult = storyInwardLinks.collect() {
    storyInwardLink ->
        "INWARD | sourceObjectKey: ${storyInwardLink.getSourceObject().getKey()}, destinationObjectId: ${storyInwardLink.getDestinationObject().getKey()}, Link type: ${storyInwardLink.getIssueLinkType().getName()}".toString()
};

// Pobranie linków wychodzących ze zgłoszenia.
List<String> storyOutwardLinksResult = storyOutwardLinks.collect() {
    storyOutwardLink ->
        "OUTWARD | sourceObjectKey: ${storyOutwardLink.getSourceObject().getKey()}, destinationObjectId: ${storyOutwardLink.getDestinationObject().getKey()}, Link type: ${storyOutwardLink.getIssueLinkType().getName()}".toString()
};

// Złączenie list linków przychodzących (inward links) i wychodzących (outward links).
storyInwardLinksResult.addAll(storyOutwardLinksResult);

// Utworzenie Stringa do prezentacji wyników.
def inwardOutwardResult = String.join("<br />", storyInwardLinksResult);

// 8. Wyświetlenie rezultatów.
/*
INWARDS: | sourceObjectKey: TL-5, destinationObjectKey: TL-1, linkType: Blocks |
OUTWARDS: | sourceObjectKey: TL-1, destinationObjectKey: TL-4, linkType: Blocks |
sourceObjectKey: TL-1, destinationObjectKey: TL-6, linkType: Relates |
-------
INWARD | sourceObjectKey: TL-5, destinationObjectId: TL-1, Link type: Blocks
OUTWARD | sourceObjectKey: TL-1, destinationObjectId: TL-4, Link type: Blocks
OUTWARD | sourceObjectKey: TL-1, destinationObjectId: TL-6, Link type: Relates
*/
return "${inwardLinksResult}<br />${outwardLinksResult}<br />-------<br />${inwardOutwardResult}";