// LISTING 13.13. Pobieranie danych o załącznikach w zgłoszeniu

import java.math.MathContext;
import java.math.RoundingMode;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.nio.file.Files;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.component.ComponentAccessor;

// 1. Pobranie obiektu typu interfejsowego Issue zgłoszenia.
def issue = ComponentAccessor.getIssueManager().getIssueObject("TP2-3");

// 2. Pobranie menedżerów.
def attachmentManager = ComponentAccessor.getAttachmentManager();
def attachmentPathManager = ComponentAccessor.getAttachmentPathManager();

// 3. Pobranie listy załączników w zgłoszeniu i wyświetlenie ich jako wartości rozdzielonych przecinkami.
List<Attachment> attachmentsList = attachmentManager.getAttachments(issue);
def allAttachments = String.join(", ", attachmentsList.collect() {attachment -> attachment.getFilename()});

// 4. Pobranie ostatnio dodanego załącznika do zgłoszenia.
def lastAddedAttechment = attachmentsList.sort() {
    attachment ->
        attachment.getCreated()
}.reverse().get(0);

// 5. Pobranie bezwzględnej ścieżki do pliku załącznika na serwerze dla wersji Jiry 8.0.x i wyższych.
// schemat: /var/atlassian/application-data/jira/data/attachments/<project key>/<bucket>
// <issue key>/<attachment id> <bucket> oznacza obecność załącznika w kontenerze 10000,
// np. załącznik o id 10001 jest w kontenerze 10000, załącznik o id 20234 jest w kontenerze 20000 itp.
def sampleAttachmentObject = attachmentsList.get(2);
def projectKey = issue.getProjectObject().getKey();
def issueKey = issue.getKey();
def attachmentsDir = attachmentPathManager.getDefaultAttachmentPath();
def bucketValue = new BigDecimal(sampleAttachmentObject.getId().toString()).round(new MathContext(1, RoundingMode.DOWN)).toLong();
def attachmentUrl = String.join("/", attachmentsDir, projectKey, bucketValue.toString(), issueKey, sampleAttachmentObject.getId().toString());

// 6. Pobranie treści załącznika tekstowego.
// Znak \n nowej linii można zastąpić innym separatorem w zależności od potrzeb.
List<String> attachmentFileLines = Files.readAllLines(Paths.get(attachmentUrl), StandardCharsets.UTF_8);
String attachmentFormattedText = String.join("\n", attachmentFileLines);

// 7. Wyświetlenie wyników.
// allAttachments: someTextFile.txt, someTextFile2.txt, someTextFile3.txt | lastAddedAttechment:
// someTextFile3.txt | attachmentUrl: /var/atlassian/application-data/jira/data/
// attachments/TP2/10000/TP2-3/10003 | attachmentFormattedText: Lorem ipsum 3
// Lorem ipsum - second line Lorem ipsum - third line
return "allAttachments: ${allAttachments} | lastAddedAttechment: ${lastAddedAttechment.getFilename()} | attachmentUrl: ${attachmentUrl} | attachmentFormattedText: ${attachmentFormattedText}";