// LISTING 13.1. Aktualizacja system fieldów w zgłoszeniu

import com.atlassian.jira.issue.label.LabelManager;
import com.atlassian.jira.event.type.EventDispatchOption;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.component.ComponentAccessor;

// 1. Pobranie obiektu DelegatingApplicationUser użytkownika admin do wykonania zmian w zgłoszeniu.
def adminUser = ComponentAccessor.getUserManager().getUserByName("admin");

// 2. Pobranie obiektu typu interfejsowego Issue zgłoszenia do edycji i zrzutowanie go do MutableIssue.
def issue = ComponentAccessor.getIssueManager().getIssueObject("TP-1") as MutableIssue;

// 3. Zmiana wartości system fieldów w zgłoszeniu.

// 3.1. Summary.
issue.setSummary("new Lorem ipsum");

// 3.2. Description.
// W polu stosuje się zapis Markup, tak jak w trybie tekstowym edycji pola.
issue.setDescription("pierwsza linia\ndrugalinia\n*test*");

// 3.3. Assignee.
// Pobranie obiektu typu interfejsowego ApplicationUser użytkownika do przypisania.
def userToAssignee = ComponentAccessor.getUserManager().getUserByName("akowalski");
issue.setAssignee(userToAssignee);

// 3.4. Reporter.
// Pobranie obiektu typu interfejsowego ApplicationUser nowego reportera.
def userToReporter = ComponentAccessor.getUserManager().getUserByName("mkonopnicka");
issue.setReporter(userToReporter);

// 3.5. Priority.
// Identyfikator priorytetu Lowest to 5.
issue.setPriorityId("5");

// 3.6. Labels.

// Pobranie komponentu LabelManager.
LabelManager labelManager = ComponentAccessor.getComponent(LabelManager.class);

// Dodanie etykiety do zgłoszenia. Ostatni parametr określa, czy ma być wysłane powiadomienie e-mailowe po zmianie.
labelManager.addLabel(adminUser, issue.id, "label4", false);

// 4. Aktualizacja zgłoszenia w Jirze.
ComponentAccessor.getIssueManager().updateIssue(adminUser, issue, EventDispatchOption.ISSUE_UPDATED, false);