// LISTING 12.19. Wyświetlenie wartości Total amount w zgłoszeniach typu Task i Sub-task

import java.math.BigDecimal;
import com.atlassian.jira.component.ComponentAccessor;

// 1. Pobranie Issue type id bieżącego zgłoszenia.
// 10002 — Task 10003 — Sub-task.
def currentIssueType = issue.getIssueTypeId();

// 2. Pobranie obiektów i wartości custom fieldów.
def priceField = ComponentAccessor.getCustomFieldManager().getCustomFieldObject(10116L);
def quantityField = ComponentAccessor.getCustomFieldManager().getCustomFieldObject(10702L);

// 3. Deklaracja zmiennej dla wyniku wyliczeń.
BigDecimal totalAmount = new BigDecimal("0");

// 4. Wyliczenie wartości Total amount dla zgłoszeń typu Sub-task.
if (currentIssueType.equals("10003")) {

    // Pobranie wartości Price i Quantity dla zgłoszenia typu Sub-task.
    BigDecimal priceFieldValue = issue.getCustomFieldValue(priceField) as BigDecimal;
    BigDecimal quantityFieldValue = issue.getCustomFieldValue(quantityField) as BigDecimal;
    
    // Wyliczenie kwoty cząstkowej dla zgłoszenia typu Sub-task.
    totalAmount = priceFieldValue.multiply(quantityFieldValue);

// 5. Wyliczenie wartości Total amount dla zgłoszenia typu Task.
} else if (currentIssueType.equals("10002")) {
    // Pobranie listy sub-tasków i przetworzenie ich w pętli each().
    issue.getSubTaskObjects().each() {
        subtask ->  
            // Pobranie wartości Price i Quantity dla iterowanego zgłoszenia typu Sub-task.
            BigDecimal subtaskPrice = subtask.getCustomFieldValue(priceField) as BigDecimal;
            BigDecimal subtaskQuantity = subtask.getCustomFieldValue(quantityField) as BigDecimal;

            // Dodanie cząstkowej sumy ze zgłoszenia typu Sub-task do Total amount
            // zgłoszenia typu Task.
            totalAmount = totalAmount.add(subtaskPrice.multiply(subtaskQuantity));
    }
}

// 6. Zwrócenie wyniku.
return totalAmount.toDouble();