// LISTING 10.25. Klasa Issues zawierająca pole z listą obiektów IssueItem
        
package pl.helion.rest.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class Issues {

    // 1. Pole przechowujące listę obiektów IssueItem.
    @XmlElement(name = "issues")
    private List<IssueItem> issues;

    // 2. Konstruktory.
    public Issues() {
        this.issues = new ArrayList<>();
    }

    // 3. Gettery i settery.
    public void setIssue(IssueItem issueItem) {
        this.issues.add(issueItem);
    }
}