// LISTING 10.15. Klasa MyConditionFactory z metodami do przetwarzania parametrów warunku przejścia

package pl.helion.jira.workflow;

import com.atlassian.jira.plugin.webresource.JiraWebResourceManager;
import com.atlassian.jira.plugin.workflow.AbstractWorkflowPluginFactory;
import com.atlassian.jira.plugin.workflow.WorkflowPluginConditionFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.ConditionDescriptor;
import javax.inject.Inject;
import java.util.HashMap;
import java.util.Map;

/**
 * Klasa fabryki parametrów dla szablonów Velocity i metody passesCondition() w klasie MyCondition.
 */
public class MyConditionFactory extends AbstractWorkflowPluginFactory implements WorkflowPluginConditionFactory {
    
    // 1. Deklaracja menedżera do zarządzania statycznymi elementami strony (resources).
    private JiraWebResourceManager jiraWebResourceManager;
    
    /**
     * 2. Konstruktor, który wstrzyknie obiekt typu interfejsowego JiraWebResourceManager.
     * @param jiraWebResourceManager
     */
    @Inject
    public MyConditionFactory(@ComponentImport JiraWebResourceManager jiraWebResourceManager) {
        this.jiraWebResourceManager = jiraWebResourceManager;
    }
    
    /**
     * 3. Metoda pobiera dane dla formularza ustawień warunku przejścia.
     * @param velocityParams — zbiór parametrów do modelu szablonu Velocity.
     */
    protected void getVelocityParamsForInput(Map velocityParams) {

        // 4. Przekazanie do modelu obiektu menedżera w celu załadowania źródeł w szablonie Velocity.
        velocityParams.put("jiraWebResourceManager", jiraWebResourceManager);
    }
    
    /**
     * 5. Metoda zwraca aktualnie zapisane dane formularza ustawień warunku przejścia do edycji.
     * @param velocityParams
     * @param descriptor
     */
    protected void getVelocityParamsForEdit(Map velocityParams, AbstractDescriptor descriptor) {
        getVelocityParamsForInput(velocityParams);
        getVelocityParamsForView(velocityParams, descriptor);
    }
    
    /**
    * 6. Metoda zwraca aktualnie zapisane dane formularza ustawień warunku przejścia dla widoku.
    * @param velocityParams
    * @param descriptor
    */
    protected void getVelocityParamsForView(Map velocityParams, AbstractDescriptor descriptor) {
        if (!(descriptor instanceof ConditionDescriptor))
            throw new IllegalArgumentException("Descriptor must be a ConditionDescriptor.");
    
        ConditionDescriptor conditionDescriptor = (ConditionDescriptor)descriptor;
        velocityParams.put("assigneeUserName", conditionDescriptor.getArgs().get("assigneeUserName"));
    }
    
    /**
     * 7. Metoda zwraca aktualnie zapisane dane ustawień warunku do wyświetlenia w liście
     * włączonych warunków przejścia.
     * @param conditionParams
     */
    public Map getDescriptorParams(Map conditionParams) {
        Map params = new HashMap();

        // 8. Przekazanie do modelu zmiennej assigneeUserName, zawierającej daną z ustawień warunku przejścia.
        params.put("assigneeUserName", extractSingleParam(conditionParams, "assigneeUserName"));
        return params;
    }
}