// LISTING 3.11. Wstrzyknięcie i użycie komponentu OptionsManager

import com.atlassian.jira.component.ComponentAccessor;

// 1. Wstrzyknięcie m.in. komponentu OptionsManager.
def customFieldManager = ComponentAccessor.getCustomFieldManager();
def optionManager = ComponentAccessor.getOptionsManager();

// 2. Pobranie obiektu typu interfejsowego Issue przykładowego zgłoszenia.
def issue = ComponentAccessor.getIssueManager().getIssueObject("BP1-3");

// 3. Pobranie obiektu typu interfejsowego CustomField pola select list (single choice).
def sampleSelectListField = customFieldManager.getCustomFieldObject(10500L);

// 4. Pobranie obiektu typu interfejsowego FieldConfig pobranego z custom fieldu.
def sampleSelectListFieldConfiguration = sampleSelectListField.getConfigurationSchemes().find() {
    configurationScheme ->
        configurationScheme.getId()==10800
}.getOneAndOnlyConfig();

// 5. Pobranie wszystkich dostępnych opcji custom fieldu za pomocą OptionsManagera.
def caseCateogryFieldOptions = optionManager.getOptions(sampleSelectListFieldConfiguration);

// 6. Wyświetlenie rezultatów.
// result: option1, option2, option3
return "result: ${String.join(", ", caseCateogryFieldOptions.collect() {option -> option.getValue();})}";