// LISTING 19.9. Edycja zgłoszenia

// 1. Token użytkownika.
def token = "OTUxODQxMjc3ODIwOs8GGxW31/mPWMI9gH0UqLp+OQRq"

// 2. URI endpointa Jira REST API.
def url = "http://172.16.117.141:8080/rest/api/2/issue/CM-9";

// 3. Zainicjowanie ciała zapytania.
def jsonBody = """
{
    "fields": {
        "summary": "New summary",
        "description": "New description",
        "assignee": {"name": "jkowalski"},
        "customfield_10115": "New text value",
        "customfield_10600": "2022-07-07",
        "customfield_10601": [{"value": "HR"}]
    }
}
""";

// 4. Otwarcie połączenia z endpointem.
def connection = url.toURL().openConnection() as HttpURLConnection;

// 5. Dodanie parametrów połączenia.
connection.setRequestMethod("PUT");
connection.addRequestProperty("Authorization", "Bearer " + token);
connection.addRequestProperty("X-Atlassian-Token", "no-check");
connection.setDoOutput(true);
connection.addRequestProperty("Content-Type", "application/json");
connection.getOutputStream().write(jsonBody.getBytes("UTF-8"))
connection.setReadTimeout(5000);
connection.connect();

// 6. Odpowiedź po wykonaniu żądania.
if (connection.getResponseCode()==204)
    println("Issue has been created");
else if (connection.getErrorStream()!=null)
    println(connection.getErrorStream().getText());

// 7. Zamknięcie połączenia.
connection.disconnect();