// LISTING 16.3. Wykonanie przejścia za pomocą komponentu IssueService

import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.component.ComponentAccessor;

// 1. Pobranie obiektu typu interfejsowego Issue zgłoszenia, na którym będzie wykonywane przejście, i zrzutowanie go do MutableIssue.
def issue = ComponentAccessor.getIssueManager().getIssueObject("WT-1") as MutableIssue;

// 2. Pobranie obiektu typu interfejsowego ApplicationUser użytkownika wykonującego przejście.
def adminUser = ComponentAccessor.getUserManager().getUserByName("admin");

// 3. Pobranie komponentu IssueService.
def issueService = ComponentAccessor.getIssueService();

// 4. Inicjalizacja komponentu do dodawania parametrów przejścia.
// W przypadku prostego przejścia definiowanie wartości nie jest konieczne.
def issueInputParameters = issueService.newIssueInputParameters();

// 5. Walidacja przejścia.
// Jako trzeci parametr metody validateTransition() należy podać identyfikator przejścia, które ma zostać wykonane.
// W poniższym przypadku 41 oznacza przejście ze statusu To Do do In Progress.
def validationResult = issueService.validateTransition(adminUser, issue.getId(), 41, issueInputParameters);

// 6. Wykonanie przejścia.
issueService.transition(adminUser, validationResult);