// LISTING 12.12. Przetwarzanie wartości z custom fieldów typu date picker i date time picker

import java.sql.Timestamp;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.UserLocaleStore;
import java.text.SimpleDateFormat;
import java.time.format.TextStyle;
import java.time.format.DateTimeFormatter;
import java.time.temporal.WeekFields;
import java.time.DayOfWeek;

// 1. Pobranie menedżerów.
def issueManager = ComponentAccessor.getIssueManager();
def customFieldManager = ComponentAccessor.getCustomFieldManager();

// 2. Pobranie przykładowego zgłoszenia według klucza.
def issue = issueManager.getIssueObject("OZP-1");

// 3. Pobranie obiektów implementujących CustomField.

// Date time picker.
def actionDateField = customFieldManager.getCustomFieldObject(10403L);

// Date picker.
def plannedResolutionDate = customFieldManager.getCustomFieldObject(10402L);

// 4. Pobranie wartości pól ze zgłoszenia.
def actionDateFieldValue = issue.getCustomFieldValue(actionDateField) as Timestamp;

// Wartość opcjonalna do podstawiania, tak jak date time picker.
def plannedResolutionDateValue = issue.getCustomFieldValue(plannedResolutionDate) as Timestamp;

// 5. Formatowanie daty metodami Timestamp.format() i LocalDateTime.format().
def date1 = actionDateFieldValue.format("yyyy-MM-dd hh:ss");
def date2 = actionDateFieldValue.format("dd.MM.yyyy");
def date3 = actionDateFieldValue.toLocalDateTime().format("yyyy-MM-dd");

// 6. Formatowanie daty lokalnej za pomocą DateTimeFormatter.
def date4 = actionDateFieldValue.toLocalDateTime().format(DateTimeFormatter.BASIC_ISO_DATE);
DateTimeFormatter dateTimeFormatter = DateTimeFormatter.BASIC_ISO_DATE;
def date5 = dateTimeFormatter.format(actionDateFieldValue.toLocalDateTime());

// 7. Formatowanie daty za pomocą SimpleDateFormat.
SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
String date6 = simpleDateFormat.format(actionDateFieldValue);

// 8. Pobieranie szczegółów daty z Timestamp i LocalDateTime;

// 8.1. Numer dnia w miesiącu.
def dayOfMonth1 = actionDateFieldValue.toMonthDay().getDayOfMonth();
def dayOfMonth2 = actionDateFieldValue.toLocalDateTime().getDayOfMonth();

// 8.2. Numer miesiąca. Uwaga! Metoda Timestamp.getMonth() zwraca liczby od 0 do 11, tj. styczeń == 0.
def month1 = actionDateFieldValue.getMonth();
def month2 = actionDateFieldValue.toLocalDateTime().getMonth().getValue();

// 8.3. Nazwa miesiąca w języku angielskim jest rzutowana bezpośrednio z wartości enum.
def monthName1 = actionDateFieldValue.toYearMonth().getMonth().toString();
def monthName2 = actionDateFieldValue.toLocalDateTime().getMonth().toString();

// 8.4. Nazwa miesiąca w wybranym języku lokalnym.
def monthName3 = actionDateFieldValue.toYearMonth().getMonth().getDisplayName(TextStyle.FULL_STANDALONE, new Locale("pl"));
def monthName4 = actionDateFieldValue.toLocalDateTime().getMonth().getDisplayName(TextStyle.FULL_STANDALONE, new Locale("pl"));

// 8.5. Nazwa miesiąca w języku zalogowanego użytkownika Jiry (ustawienia profilu).
def monthName5 = actionDateFieldValue.toYearMonth().getMonth().getDisplayName(TextStyle.FULL_STANDALONE,ComponentAccessor.getJiraAuthenticationContext().getLocale());
def monthName6 = actionDateFieldValue.toLocalDateTime().getMonth().getDisplayName(TextStyle.FULL_STANDALONE,ComponentAccessor.getJiraAuthenticationContext().getLocale());

// 8.6. Nazwa miesiąca w domyślnym języku wybranego użytkownika.
def user = ComponentAccessor.getUserManager().getUserByName("admin");
UserLocaleStore localeStore = ComponentAccessor.getComponentOfType(UserLocaleStore.class);
Locale loggedInUserlocale = localeStore.getLocale(user);
def monthName7 = actionDateFieldValue.toYearMonth().getMonth().getDisplayName(TextStyle.FULL_STANDALONE, loggedInUserlocale);
def monthName8 = actionDateFieldValue.toLocalDateTime().getMonth().getDisplayName(TextStyle.FULL_STANDALONE, loggedInUserlocale);

// 8.7. Numer dnia tygodnia według ustawień lokalnych.
// Uwaga! W niektórych kalendarzach pierwszym dniem tygodnia jest niedziela.
// Należy zwrócić szczególną uwagę na aktualne ustawienia Locale w aplikacji i na serwerze.
def dayOfWeek1 = actionDateFieldValue.toDayOfWeek().getValue();
def dayOfWeek2 = actionDateFieldValue.toLocalDateTime().getDayOfWeek().getValue();

// 8.8. Numer dnia tygodnia po zdefiniowaniu niedzieli jako pierwszego dnia tygodnia.
WeekFields weekFields1 = WeekFields.of(DayOfWeek.SUNDAY, 1);
def dayOfWeek3 = actionDateFieldValue.toLocalDateTime().get(weekFields1.dayOfWeek());

// 8.9. Nazwa dnia tygodnia w języku angielskim rzutowana bezpośrednio z wartości enum.
def nameOfDay1 = actionDateFieldValue.toDayOfWeek().toString();
def nameOfDay2 = actionDateFieldValue.toLocalDateTime().getDayOfWeek().toString();

// 8.10. Nazwa dnia tygodnia w dowolnym języku lokalnym.
def nameOfDay3 = actionDateFieldValue.toDayOfWeek().getDisplayName(TextStyle.FULL_STANDALONE, new Locale("pl"));
def nameOfDay4 = actionDateFieldValue.toLocalDateTime().getDayOfWeek().getDisplayName(TextStyle.FULL_STANDALONE, new Locale("pl"));

// 8.11. Nazwa dnia tygodnia w języku zalogowanego użytkownika Jiry (ustawienia profilu).
def nameOfDay5 = actionDateFieldValue.toDayOfWeek().getDisplayName(TextStyle.FULL_STANDALONE,ComponentAccessor.getJiraAuthenticationContext().getLocale());
def nameOfDay6 = actionDateFieldValue.toLocalDateTime().getDayOfWeek().getDisplayName(TextStyle.FULL_STANDALONE,ComponentAccessor.getJiraAuthenticationContext().getLocale());

// 8.12. Nazwa dnia tygodnia w domyślnym języku wybranego użytkownika.
def nameOfDay7 = actionDateFieldValue.toDayOfWeek().getDisplayName(TextStyle.FULL_STANDALONE, loggedInUserlocale);
def nameOfDay8 = actionDateFieldValue.toLocalDateTime().getDayOfWeek().getDisplayName(TextStyle.FULL_STANDALONE, loggedInUserlocale);

// 8.13. Numer tygodnia w miesiącu — tydzień rozumiany jako tydzień miesiąca (od 4 do 6 tygodni).
// Początkiem tygodnia jest poniedziałek.
WeekFields weekFields2 = WeekFields.of(DayOfWeek.MONDAY, 1);
def numberOfWeek1 = actionDateFieldValue.toLocalDateTime().get(weekFields2.weekOfMonth());

// 8.14. Pobranie czasu z obiektów Timestamp i LocalDateTime.
def time1 = actionDateFieldValue.getTimeString();
def time2 = actionDateFieldValue.toLocalDateTime().getTimeString();

// 8.15. Pobranie godziny, minuty, sekundy, milisekundy z obiektu Timestamp.
def time3 = actionDateFieldValue.format("HH:mm:ss:sss");
def timeHours = actionDateFieldValue.getHours();
def timeMinutes = actionDateFieldValue.getMinutes();
def timeSeconds = actionDateFieldValue.getSeconds();
def timeMiliseconds = actionDateFieldValue.format("sss");

// 9. Wyświetlenie wyników.
// date1: 2022-06-15 10:00 | date2: 15.06.2022 | date3: 2022-06-15 | date4: 20220615 |
// date5: 20220615 | date6: 2022-06-15 | day1: 15 | day2: 15 | month1: 5 | month2: 6 |
// monthName1: JUNE | monthName2: JUNE | monthName3: czerwiec | monthName4: czerwiec |
// monthName5: June | monthName6: June | monthName7: June | monthName8: June |
// dayOfWeek1: 3 | dayOfWeek2: 3 | dayOfWeek3: 4 | nameOfDay1: WEDNESDAY | nameOfDay2:
// WEDNESDAY | nameOfDay3: środa | nameOfDay4: środa | nameOfDay5: Wednesday |
// nameOfDay6: Wednesday | nameOfDay7: Wednesday | nameOfDay8: Wednesday |
// numberOfWeek1: 3 | time1: 10:34:00 PM | time2: 22:34:00 | time3: 22:34:00:000 | timeHours: 22 |
// timeMinutes: 34 | timeSeconds: 0 | timeMiliseconds: 000
return "date1: ${date1} | date2: ${date2} | date3: ${date3} | date4: ${date4} | date5: ${date5} | date6: ${date6} | day1: ${dayOfMonth1} | day2: ${dayOfMonth2} | month1: ${month1} | month2: ${month2} | monthName1: ${monthName1} | monthName2: ${monthName2} | monthName3: ${monthName3} | monthName4: ${monthName4} | monthName5: ${monthName5} | monthName6: ${monthName6} | monthName7: ${monthName7} | monthName8: ${monthName8} | dayOfWeek1: ${dayOfWeek1} | dayOfWeek2: ${dayOfWeek2} | dayOfWeek3: ${dayOfWeek3} | nameOfDay1: ${nameOfDay1} | nameOfDay2: ${nameOfDay2} | nameOfDay3: ${nameOfDay3} | nameOfDay4: ${nameOfDay4} | nameOfDay5: ${nameOfDay5} | nameOfDay6: ${nameOfDay6} | nameOfDay7: ${nameOfDay7} | nameOfDay8: ${nameOfDay8} | numberOfWeek1: ${numberOfWeek1} | time1: ${time1} | time2: ${time2} | time3: ${time3} | timeHours: ${timeHours} | timeMinutes: ${timeMinutes} | timeSeconds: ${timeSeconds} | timeMiliseconds: ${timeMiliseconds}";