 -- Deklaracja protokou SuperFunkyChat dla dysekcji
chat_proto = Proto("chat","SuperFunkyChat Protocol")
-- Specyfikacja pl protokou
chat_proto.fields.chksum = ProtoField.uint32("chat.chksum", "Checksum", base.HEX)
chat_proto.fields.command = ProtoField.uint8("chat.command", "Command")
chat_proto.fields.data = ProtoField.bytes("chat.data", "Data")

-- Funkcja wyodrbniajca acuch znakw z pola binarnego
-- buffer: Obiekt TVB zawierajcy dane pakietu
-- start: Offset pocztku odczytywanego acucha
-- wynik: odczytany acuch oraz jego dugo
function read_string(buffer, start)
    local len = buffer(start, 1):uint()
    local str = buffer(start + 1, len):string()
    return str, (1 + len)
end

-- Funkcja dysektora:
-- buffer: Dane pakietu UDP jako "Testy Virtual Buffer" (TVB)
-- pinfo: Informacja o pakiecie
-- tree: Korze drzewa UI
function chat_proto.dissector(buffer, pinfo, tree)
    -- Wywietlana w kolumnie protokou
    pinfo.cols.protocol = "CHAT"
    
    -- Tworzenie poddrzewa reprezentujcego cay bufor
    local subtree = tree:add(chat_proto,
                             buffer(),
                             "Dane protokou SuperFunkyChat ")
    subtree:add(chat_proto.fields.chksum, buffer(0, 4))
    subtree:add(chat_proto.fields.command, buffer(4, 1))
    -- Utworzenie obiektu TVB reprezentujcego pole danych pakietu
    local data = buffer(5):tvb()
    local datatree = subtree:add(chat_proto.fields.data, data())
    
    local MESSAGE_CMD = 3
    local command = buffer(4, 1):uint()
    if command == MESSAGE_CMD then
        local curr_ofs = 0
        local str, len = read_string(data, curr_ofs)
        datatree:add(chat_proto, data(curr_ofs, len), "Username: " .. str)
        curr_ofs = curr_ofs + len
        str, len = read_string(data, curr_ofs)
        datatree:add(chat_proto, data(curr_ofs, len), "Message: " .. str)
    end
end

-- Dodanie portu 12345 do tablicy dysektora
udp_table = DissectorTable.get("udp.port")
udp_table:add(12345, chat_proto)
