﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KsiegaGosci
{
    public partial class Default : System.Web.UI.Page
    {
        Wpisy wpisy;

        protected void Page_Load(object sender, EventArgs e)
        {
            wpisy = (Wpisy)Application[Global.nazwaZmiennej_Wpisy];
        }

        protected void Page_Init(object sender, EventArgs e)
        {
            if (TextBox1.Text == "")
            {
                string nazwaUżytkownika = PrzypomnijNazwęUżytkownika();
                if (nazwaUżytkownika != null) TextBox1.Text = nazwaUżytkownika;
            }
        }

        //kontroler (tylko tu model może być zmieniany)
        protected void Button1_Click(object sender, EventArgs e)
        {
            if (TextBox1.Text == "" || TextBox2.Text == "") return; //walidacja po stronie serwera

            //Wpis nowyWpis=new Wpis(TextBox1.Text.Trim(),TextBox2.Text.Trim(),DateTime.Now,Request.UserHostAddress);
            Wpis nowyWpis = new Wpis() 
            { 
                NazwaUżytkownika = TextBox1.Text.Trim(), 
                Treść = TextBox2.Text.Trim(), 
                Data = DateTime.Now, 
                AdresIP = Request.UserHostAddress 
            };
            wpisy.Dodaj(nowyWpis);

            //odświeżanie danych
            LinqDataSource1.DataBind();
            Repeater1.DataBind();

            TextBox2.Text = ""; //czyszczenie pola edycyjnego z treścią wpisu
            ZapamietajNazwęUżytkownika(TextBox1.Text); //zapis do cookie
        }

        #region Przechowywanie nazwy użytkownika w ciasteczku
        void ZapamietajNazwęUżytkownika(string nazwaUżytkownika)
        {
            HttpCookie ciasteczko = new HttpCookie("imie", nazwaUżytkownika);
            ciasteczko.Expires = DateTime.Today.AddDays(3);
            Response.Cookies.Add(ciasteczko);
        }

        string PrzypomnijNazwęUżytkownika()
        {
            if (Request.Cookies["imie"] != null) return Request.Cookies["imie"].Value;
            else return null;
        }
        #endregion
    }
}