﻿using Microsoft.AspNetCore.Http;
using System;
using System.Threading.Tasks;

namespace Platform
{
    public class Population
    {
        public static async Task Endpoint(HttpContext context)
        {
            string city = context.Request.RouteValues["city"] as string ?? "londyn";
            int? pop = null;
            switch (city.ToLower())
            {
                case "londyn":
                        pop = 8_136_000;
                        break;
                    case "madryt":
                        pop = 3_266_000;
                        break;
                    case "monako":
                        pop = 39_000;
                        break;
            }
            if (pop.HasValue)
            {
                await context.Response
                    .WriteAsync($"miasto: {city}, populacja: {pop}");
            }
            else
            {
                context.Response.StatusCode = StatusCodes.Status404NotFound;
            }
        }
    }
}