﻿using System.ComponentModel.DataAnnotations.Schema;
using System.ComponentModel.DataAnnotations;
using Microsoft.AspNetCore.Mvc.ModelBinding;
using WebApp.Validation;
using Microsoft.AspNetCore.Mvc;

namespace WebApp.Models
{
    [PhraseAndPrice(Phrase = "Mały", Price = "100")]
    public class Product
    {
        public long ProductId { get; set; }

        [Required]
        [Display(Name = "Produkt")]
        public string Name { get; set; }

        [Column(TypeName = "decimal(8, 2)")]
        [Required(ErrorMessage = "Proszę podać cenę.")]
        [Range(1, 999999, ErrorMessage = "Proszę podać wartość dodatnią.")]
        public decimal Price { get; set; }

        [PrimaryKey(ContextType = typeof(DataContext), DataType = typeof(Category))]
        [Remote("CategoryKey", "Validation", ErrorMessage = "Podaj istniejący klucz.")]
        public long CategoryId { get; set; }

        public Category Category { get; set; }

        [PrimaryKey(ContextType = typeof(DataContext), DataType = typeof(Category))]
        [Remote("CategoryKey", "Validation", ErrorMessage = "Podaj istniejący klucz.")]
        public long SupplierId { get; set; }

        public Supplier Supplier { get; set; }
    }
}