﻿using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;

namespace Advanced.Models
{
    public class Person
    {
        public long PersonId { get; set; }

        [Required(ErrorMessage = "Podanie imienia jest wymagane.")]
        [MinLength(3, ErrorMessage = "Imię musi mieć co najmniej 3 znaki.")]
        public string Firstname { get; set; }
        
        [Required(ErrorMessage = "Podanie nazwiska jest wymagane.")]
        [MinLength(3, ErrorMessage = "Nazwisko musi mieć co najmniej 3 znaki.")]
        public string Surname { get; set; }
        
        [Required]
        [Range(1, long.MaxValue,
            ErrorMessage = "Wybranie działu jest wymagane.")]
        public long DepartmentId { get; set; }

        [Required]
        [Range(1, long.MaxValue,
            ErrorMessage = "Wybranie lokalizacji jest wymagane.")]
        public long LocationId { get; set; }

        public Department Department { get; set; }

        public Location Location { get; set; }
    }
}