﻿using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using System.Collections.Generic;
using System.Linq;

namespace Platform.Models
{
    public class SeedData
    {
        private CalculationContext context;
        private ILogger<SeedData> logger;
        private static Dictionary<int, long> data
            = new Dictionary<int, long>() {
                {1, 1}, {2, 3}, {3, 6}, {4, 10}, {5, 15},
                {6, 21}, {7, 28}, {8, 36}, {9, 45}, {10, 55}
            };
        public SeedData(CalculationContext dataContext, ILogger<SeedData> log)
        {
            context = dataContext;
            logger = log;
        }
        public void SeedDatabase()
        {
            context.Database.Migrate();
            if (context.Calculations.Count() == 0)
            {
                logger.LogInformation("przygotowanie do umieszczenia informacji w bazie danych");
                context.Calculations!.AddRange(data.Select(kvp => new Calculaton()
                {
                    Count = kvp.Key,
                    Result = kvp.Value
                }));
                context.SaveChanges();
                logger.LogInformation("baza danych jest przygotowana");
            }
            else
            {
                logger.LogInformation("baza danych nie jest przygotowana");
            }
        }
    }
}