using System;
using System.Collections.Generic;
using PartyInvites.Controllers;
using PartyInvites.Models;
using Xunit;
using Microsoft.AspNetCore.Mvc;
using System.Linq;

namespace Tests
{
    public class HomeControllerTests
    {
        [Fact]
        public void ListActionFiltersNonAttendees()
        {
            // Przygotowanie.
            HomeController controller = new HomeController(new FakeRepository());
            // Działanie.
            ViewResult result = controller.ListResponses();
            // Asercje.
            Assert.Equal(2, (result.Model as IEnumerable<GuestResponse>).Count());
        }
    }

    class FakeRepository : IRepository
    {
        public IEnumerable<GuestResponse> Responses =>
            new List<GuestResponse> {
                new GuestResponse { Name = "Bartek", WillAttend = true },
                new GuestResponse { Name = "Alicja", WillAttend = true },
                new GuestResponse { Name = "Jan", WillAttend = false }
            };

        public void AddResponse(GuestResponse response)
        {
            throw new NotImplementedException();
        }
    }
}