﻿using System;
using System.ComponentModel.DataAnnotations;
using ModelValidation.Infrastructure;
using Microsoft.AspNetCore.Mvc;

namespace ModelValidation.Models
{
    public class Appointment
    {
        [Required]
        [Display(Name = "name")]
        public string ClientName { get; set; }


        [UIHint("Date")]
        [Required(ErrorMessage = "Proszę podać datę w przyszłości.")]
        [Remote("ValidateDate", "Home")]
        public DateTime Date { get; set; }

        [MustBeTrue(ErrorMessage = "Zaakceptowanie warunków jest wymagane.")]
        public bool TermsAccepted { get; set; }
    }
}