var gulp  = require('gulp'),
    del = require("del"),
    concat = require('gulp-concat'),
    jshint = require('gulp-jshint'),
    cssmin = require('gulp-cssmin'),
    sourcemaps = require('gulp-sourcemaps'),
    uglify = require('gulp-uglify');

var stylish = require('jshint-stylish');

var pkg = require('./package.json');

gulp.task("clean", function() {
  return del("lib/*");
});

gulp.task("lint", function() {
  return gulp.src("src/scripts/*.js")
    .pipe(jshint())
    .pipe(jshint.reporter('default'))
    //.pipe(jshint.reporter('jshint-stylish'))
    .pipe(jshint.reporter('fail'));
});

gulp.task("minjs", ["clean","lint"], function(){
  return gulp.src("src/scripts/*.js")
    .pipe(sourcemaps.init())
      .pipe(concat(pkg.name+"-"+pkg.version+".min.js"))
      .pipe(uglify())
    .pipe(sourcemaps.write('.'))
    .pipe(gulp.dest("lib"));
});

gulp.task("mincss", ["clean"], function(){
  return gulp.src("src/css/*.css")
    .pipe(concat("styles.css"))
    .pipe(cssmin())
    .pipe(gulp.dest("lib"));
});

gulp.task("default", ["mincss","minjs"]);

gulp.task('watch', function() {
  gulp.watch('src/scripts/*.js', ['lint']);
});
