﻿import { Injectable } from '@angular/core';
import { TimingPoint } from './TimingPoint';
import { Athlete } from './athlete';
import { Http, Response } from "@angular/http";
import 'rxjs/add/operator/map';
import 'rxjs/add/operator/toPromise';

@Injectable()
export class AthleteService {
  constructor(private http: Http){}

  getAthletes(){
    return this.http.get('/api/standings')
      .map((r: Response) => <Athlete[]>r.json().data)
      .toPromise();
  }

  getTimingPoints() {
      return this.http.get('/api/timingpoints')
          .map((r: Response) => <TimingPoint[]>r.json())
          .toPromise();
  }
}