﻿<%@ Page Language="VB" AutoEventWireup="true" CodeFile="OrderForm.aspx.vb" Inherits="_Default" %>

<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="cc1" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
	<style type="text/css">@import url(StyleSheet.css);</style>
    <title>AdventureWorks - PopupControlExtender</title>
</head>
<body>
    <form id="form1" runat="server">
        <asp:ScriptManager ID="ScriptManager1" runat="server" />
        <div>
        <h1>Formularz Zamówienia Firmy AdventureWorks</h1>
            <table>
                <tr>
                    <td style="width: 100px">
                        Imię i nazwisko klienta:</td>
                    <td style="width: 100px">
                        <asp:TextBox ID="txtName" runat="server" 
							CssClass="unwatermarked">
						</asp:TextBox>
						<cc1:TextBoxWatermarkExtender ID="CustomerNameWatermark" runat="server" 
							TargetControlID="txtName"
							WatermarkCssClass="watermarked"
							WatermarkText="Twoje imię i nazwisko">
						</cc1:TextBoxWatermarkExtender>
                    </td>
                </tr>
                <tr>
                    <td style="width: 100px">
                        Adres:</td>
                    <td style="width: 100px">
                        <asp:TextBox ID="txtAddress" runat="server" 
							CssClass="unwatermarked"></asp:TextBox>
						<cc1:TextBoxWatermarkExtender ID="CustomerAddressWatermark" runat="server" 
							TargetControlID="txtAddress"
							WatermarkCssClass="watermarked"
							WatermarkText="Adres domowy">
						</cc1:TextBoxWatermarkExtender>
                    </td>
                </tr>
                <tr>
                    <td style="width: 100px">
                        City:</td>
                    <td style="width: 100px">
                        <asp:TextBox ID="txtCity" runat="server"></asp:TextBox></td>
                </tr>
                <tr>
                    <td style="width: 100px">
                        Stan:</td>
                    <td style="width: 100px">
                        <asp:DropDownList ID="ddlState" runat="server">
                            <asp:ListItem Value="AL">Alabama</asp:ListItem>
                            <asp:ListItem Value="AK">Alaska</asp:ListItem>
                            <asp:ListItem Value="CA">California</asp:ListItem>
                            <asp:ListItem Value="CT">Connecticut</asp:ListItem>
                            <asp:ListItem Value="FL">Florida</asp:ListItem>
                            <asp:ListItem Value="PA">Pennsylvania</asp:ListItem>
                            <asp:ListItem Value="TX">Texas</asp:ListItem>
                            <asp:ListItem></asp:ListItem>
                        </asp:DropDownList></td>
                </tr>
                <tr>
                    <td style="width: 100px">
                        Kod pocztowy:</td>
                    <td style="width: 100px">
                        <asp:TextBox ID="txtZip" runat="server"></asp:TextBox></td>
                </tr>
                <tr>
                    <td style="width: 100px">
                        E-mail:</td>
                    <td style="width: 100px">
                        <asp:TextBox ID="txtEmail" runat="server"></asp:TextBox></td>
                </tr>
                <tr>
                    <td style="width: 100px">
                        Hasło:</td>
                    <td style="width: 100px">
                        <asp:TextBox ID="txtPassword" runat="server" TextMode="Password"></asp:TextBox></td>
                </tr>
                <tr>
                    <td style="width: 100px">
                        Komentarz:</td>
                    <td style="width: 100px">
                        <asp:TextBox ID="txtComment" runat="server" Rows="3" TextMode="MultiLine" Width="300px"></asp:TextBox></td>
                </tr>
            </table>
        </div>
		<asp:UpdatePanel ID="UpdatePanel1" runat="server">
			<ContentTemplate>
        Chcę udostępnić dane osobiste:
        <asp:RadioButton ID="rbYes" runat="server" AutoPostBack="True" Checked="True" 
            GroupName="grpPersonalInfo"
            Text="Tak" ToolTip="Podaj dane osobiste" />
        <asp:RadioButton ID="rbNo" runat="server" AutoPostBack="True" 
            GroupName="grpPersonalInfo"
            Text="Nie" ToolTip="Nie podawaj osobistych danych" /><br />
        <asp:Panel ID="pnlPersonalInfo" runat="server" Height="50px" Width="125px" BorderWidth="1px">
            <table>
                <tr valign="top">
                    <td style="width: 367px" >
                        Zainteresowania<br />
                        <asp:CheckBoxList ID="cblAreas" runat="server" AutoPostBack="True" Width="190px">
                            <asp:ListItem>Jazda na rowerze</asp:ListItem>
                            <asp:ListItem>Nurkowanie</asp:ListItem>
                            <asp:ListItem>Gry zręcznościowe</asp:ListItem>
                            <asp:ListItem>Wspinaczka g&#243;rska</asp:ListItem>
                            <asp:ListItem>Surfowanie po Internecie</asp:ListItem>
                            <asp:ListItem>Windsurfing</asp:ListItem>
                        </asp:CheckBoxList></td>
                    <td style="width: 10885px">
                        Przedział wieku&nbsp;<br />
						<asp:TextBox ID="txtAgeCategory" runat="server" Width="280px"></asp:TextBox>

						<cc1:TextBoxWatermarkExtender ID="TextBoxWatermarkExtender1" 
							runat="server" 
							TargetControlID="txtAgeCategory" 
							WatermarkText="Kliknij, by wyświetlić dostępne kategorie">
						</cc1:TextBoxWatermarkExtender>
						
						<cc1:PopupControlExtender ID="PopupControlExtender1" 
							runat="server" 
							TargetControlID="txtAgeCategory" 
							PopupControlID="pnlAgeCategories" 
							Position="Bottom">
						</cc1:PopupControlExtender>
						<asp:Panel ID="pnlAgeCategories" runat="server" Height="50px" 
							Width="125px">
							<asp:UpdatePanel ID="UpdatePanel2" runat="server">
								<ContentTemplate>
									<asp:RadioButtonList ID="rblAge" runat="server" 
											AutoPostBack="True" Width="125px" 
											OnSelectedIndexChanged="rblAge_SelectedIndexChanged">
										<asp:ListItem Value="Poniżej 21 - Ciesz się!">Poniżej 21</asp:ListItem>
										<asp:ListItem Value="21 do 30 - Życie na maksa">Od 21 do 30
												</asp:ListItem>
										<asp:ListItem Value="31 do 50 - Życie jest piękne">Od 31 do 50
												</asp:ListItem>
										<asp:ListItem Value="Powyżej 50 - Złote lata">Powyżej 50
												</asp:ListItem>
									</asp:RadioButtonList>
								</ContentTemplate>
							</asp:UpdatePanel>
						</asp:Panel>
                        &nbsp;
					</td>
                </tr>
            </table>
        </asp:Panel>
			</ContentTemplate>
		</asp:UpdatePanel>
        <br />

    </form>
</body>
</html>
