Imports System.Data
Imports System.Data.SqlClient

Partial Class CityLookup
    Inherits System.Web.UI.Page

	Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) _
						   Handles Me.Load
		If (Request.QueryString.Count > 0) Then
			Dim queryCityName As String = Request.QueryString.Get(0).ToString()
			Dim dt As DataTable = CitiesForPartialName(queryCityName)

			If (dt Is Nothing Or dt.Rows.Count = 0) Then
				CityNames.Text = _
						"Sorry no cities found with that letter combination"
			Else
				Dim returnString As String = String.Empty
				returnString = returnString + _
						"<select id='slctCity' size=5 onchange=""SelectCity();"">"
				Dim row As DataRow
				For Each row In dt.Rows
					returnString = returnString + "<option value='" + _
					   row("City").ToString() + "' >" + _
					   row("City").ToString() + _
					   "</option>"
				Next
				returnString = returnString + "</select>"
				CityNames.Text = returnString

			End If

		Else
			CityNames.Text = String.Empty
		End If
	End Sub

	Public Function CitiesForPartialName(ByVal aPartialName As String) As DataTable
		Dim connectionString As String = _
				ConfigurationManager.AppSettings("AdventureWorks")
		Dim connection As SqlConnection = New SqlConnection(connectionString)

		Dim queryString As String = _
				"select distinct City from Person.Address where City like '" + _
				aPartialName + "%' order by City"
		Dim ds As DataSet = New DataSet()

		Try
			Dim dataAdapter As SqlDataAdapter = _
			   New SqlDataAdapter(queryString, connection)
			dataAdapter.Fill(ds, "Cities")
		Catch ex As Exception
			'' Handle exception
			CityNames.Text = ex.Message
		Finally
			connection.Close()
		End Try

		Return ds.Tables("Cities")

	End Function

End Class
