
Partial Class Welcome
    Inherits System.Web.UI.Page

Protected Sub Button1_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnManagersPage.Click
	Response.Redirect("ManagersPage.aspx")
End Sub

Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
	If User.Identity.IsAuthenticated = True Then
		btnManagersPage.Enabled = True
	Else
		btnManagersPage.Enabled = False
	End If

	If Not IsPostBack And _
			Profile.UserName IsNot Nothing Then
		If Profile.IsAnonymous = False Then
			Me.pnlInfo.Visible = True
			Me.lblFullName.Text = Profile.firstName & " " & Profile.lastName
			Me.lblPhone.Text = Profile.phoneNumber
			Me.lblBirthDate.Text = Profile.birthDate.ToShortDateString()
		End If

		 If Profile.Sports IsNot Nothing Then
			For Each sport As String In Profile.Sports
				Me.lbSports.Items.Add(sport)
			Next
		End If
	Else
		Me.pnlInfo.Visible = False
	End If

End Sub

	Public Overrides Property StyleSheetTheme() As String
		Get
			If Profile.IsAnonymous = False _
			And Profile.Theme IsNot Nothing Then
				Return Profile.Theme
			Else
				Return "Dark Blue"
			End If
		End Get
		Set(ByVal value As String)
			Profile.Theme = value
		End Set
	End Property

Protected Sub Page_PreInit(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.PreInit
	If Profile.IsAnonymous = False Then
		Page.Theme = Profile.Theme
	End If
End Sub
End Class
