﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Views/Shared/Site.Master" Inherits="System.Web.Mvc.ViewPage<SportsStore.Models.CartIndexViewModel>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server"> 
    Sklep sportowy : Twój koszyk 
</asp:Content> 
 
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server"> 
    <h2>Twój koszyk</h2> 
    <table width="90%" align="center"> 
        <thead><tr> 
            <th align="center">Ilość</th> 
            <th align="left">Produkt</th> 
            <th align="right">Cena</th> 
            <th align="right">Wartość</th> 
        </tr></thead> 
        <tbody> 
        <% foreach(var line in Model.Cart.Lines) { %> 
            <tr> 
                <td align="center"><%: line.Quantity %></td> 
                <td align="left"><%: line.Product.Name %></td> 
                <td align="right"><%: line.Product.Price.ToString("c") %></td> 
                <td align="right"> 
                    <%: (line.Quantity*line.Product.Price).ToString("c") %> 
                </td> 
                <td> 
                    <% using(Html.BeginForm("RemoveFromCart", "Cart")) { %> 
                        <%: Html.Hidden("ProductId", line.Product.ProductID) %> 
                        <%: Html.HiddenFor(x => x.ReturnUrl) %> 
                        <input type="submit" value="Usuń" /> 
                    <% } %> 
                </td> 
            </tr> 
        <% } %> 
        </tbody> 
        <tfoot><tr> 
            <td colspan="3" align="right">Razem:</td> 
            <td align="right"> 
                <%: Model.Cart.ComputeTotalValue().ToString("c") %> 
            </td> 
        </tr></tfoot> 
    </table> 
    <p align="center" class="actionButtons"> 
        <a href="<%: Model.ReturnUrl %>">Kontynuuj zakupy</a> 
            <%: Html.ActionLink("Zamówienie", "CheckOut") %> 
     </p> 
</asp:Content> 

