﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Routing;
using System.Web.Mvc;

namespace AplikacjaMVC.Infrastructure
{
    public class LegacyRoute : RouteBase
    {
        private string[] urls;
        public LegacyRoute(params string[] targetUrls)
        {
            urls = targetUrls;
        }
        public override RouteData GetRouteData(HttpContextBase httpContext)
        {
            RouteData result = null;
            string requestedURL =
            httpContext.Request.AppRelativeCurrentExecutionFilePath;
            if (urls.Contains(requestedURL, StringComparer.OrdinalIgnoreCase))
            {
                result = new RouteData(this, new MvcRouteHandler());
                result.Values.Add("controller", "Legacy");
                result.Values.Add("action", "GetLegacyURL");
                result.Values.Add("legacyURL", requestedURL);
            }
            return result;
        }
        public override VirtualPathData GetVirtualPath(RequestContext requestContext,
        RouteValueDictionary values)
        {
            return null;
        }
    }
}