﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NUnit.Framework;
using System.Web.Mvc;
using SportsStore.Models;
using SportsStore.HtmlHelpers;

namespace SportsStore.UnitTests
{
    [TestFixture]
    public class DisplayingPageLinks
    {
        [Test]
        public void Can_Generate_Links_To_Other_Pages()
        {
            // Przygotowanie: Zamierzamy rozszerzyć klasę HtmlHelper. 
            // Nie ma znaczenia, jeżeli używana zmienna ma wartość null. 
            HtmlHelper html = null;

            // Przygotowanie: Metoda powinna użyć instancji PagingInfo (jest to klasa
            // której jeszcze nie zdefiniowaliśmy) oraz lambda definiującej adresy URL 
            PagingInfo pagingInfo = new PagingInfo
            {
                CurrentPage = 2,
                TotalItems = 28,
                ItemsPerPage = 10
            };
            Func<int, string> pageUrl = i => "Strona" + i;

            // Działanie
            MvcHtmlString result = html.PageLinks(pagingInfo, pageUrl);

            // Asercja: Łącza powinny być sformatowane w następujący sposób 
            result.ToString().ShouldEqual(@"<a href=""Strona1"">1</a> 
<a class=""selected"" href=""Strona2"">2</a> 
<a href=""Strona3"">3</a> 
");
        }
    }
}
