﻿$(document).ready(function () {
    //konfiguracja autouzupełniania jquery
    $("#autocomplete").autocomplete({
        minLength: 2, // Wymaganie wpisania co najmniej dwóch znaków przed rozpoczęciem działania.
        source: function (req, resp) { // Pobranie obiektu wyników z kontrolera ZdjeciaController.
            $.ajax({
                url: "/Zdjecia/PobierzKlucze", // Link do metody zwracającej obiekt Json.
                type: "POST",
                dataType: "json",
                data: { szukanaFraza: req.term }, // szukanaFraza - nazwa parametru metody w kontrolerze.
                success: function (data) {
                    resp($.map(data, function (item) {
                        return { label: item.Klucz, value: item.Wartosc }; // Obiekt wynikowy będzie miał prostą strukturą, będzie zawierał pole Klucz i Wartosc.
                    }));
                }
            });
        },
        select: function (event, ui) { // Zdefiniowanie akcji jaka zostanie wykonana po wybranie z listy którego ze zdjęć.
            if (ui.item.value !== null) {
                window.location.replace('http://' + location.host + '/Zdjecia/Details/' + ui.item.value);
                // Przeniesienie użytkownika do szczegółów zdjęcia na podstawie ID zdjęcia, które znajdowało się w strukturze wynikowe JSON.       
            }
        }
    });
    // Ustawienie akcji, która ma nastąpić po kliknięciu - tutaj wywołanie metody zdefiniowanej wyżej.
    $("#autocomplete").click(function () {
        $(this).select();
    });
});
