﻿using System;
using System.Linq;
using PortalUslug.Models;

namespace PortalUslug.Repositories
{
    /// <summary>
    /// Interfejs repozytorium usługobiorcy.
    /// </summary>
    public interface ICustomerRepository : IRepository<Customer>
    {
        /// <summary>
        /// Pobranie usługobiorcy o podanym identyfikatorze.
        /// </summary>
        /// <param name="id">Identyfikator usługobiorcy.</param>
        /// <returns>Usługobiorca o podanym identyfikatorze.</returns>
        Customer GetCustomerById(int id);
        
        /// <summary>
        /// Pobranie usługobiorcy o podanym identyfikatorze użytkownika.
        /// </summary>
        /// <param name="id">Identyfikator użytkownika.</param>
        /// <returns> Usługobiorca o podanym identyfikatorze użytkownika.</returns>
        Customer GetCustomerByUserId(int id);

        /// <summary>
        /// Pobranie usługobiorców z newsletterem.
        /// </summary>
        /// <returns>Usługobiorcy z newsletterem.</returns>
        IQueryable<Customer> GetAllCustomersWithNewsletter();

        /// <summary>
        /// Sprawdzenie, czy usługobiorca o podanym identyfikatorze użytkownika jest usługobiorcą.
        /// </summary>
        /// <param name="id">Identyfikator użytkownika.</param>
        /// <returns>True, jeśli użytkownik o podanym identyfikatorze jest usługobiorcą.</returns>
        bool IsCustomer(int id);

        /// <summary>
        /// Sprawdzenie, czy usługobiorca o podanym identyfikatorze użytkownika ma potwierdzone konto.
        /// </summary>
        /// <param name="id">Identyfikator użytkownika.</param>
        /// <returns>True, jeśli użytkownik o podanym identyfikatorze ma potwierdzone konto.</returns>
        bool IsConfirmed(int id);

        /// <summary>
        /// Pobranie wszystkich usługobiorców.
        /// </summary>
        /// <returns>Usługobiorcy.</returns>
        IQueryable<CustomerViewModel> GetAllCustomers();
    }
}
