﻿using System.Web.Mvc;
using PortalUslug.Models;
using PortalUslug.Repositories;

namespace PortalUslug.Controllers
{
    [Authorize(Roles = "Administrator")]
    public class CommentCategoryController : Controller
    {
        /// <summary>
        /// Repozytorium kategorii.
        /// </summary>
        private CategoryRepository _categoryRepo;

        /// <summary>
        /// Konstruktor kontrolera kategorii komentarzy.
        /// </summary>
        public CommentCategoryController()
        {
            _categoryRepo = new CategoryRepository();
        }


        //
        // GET: /CommentCategory/

        public ActionResult Index()
        {
            // Pobranie listy kategorii komentarzy
            var categoriesList = _categoryRepo.GetAllCommentCategories();
            return View(categoriesList);
        }

        //
        // GET: /CommentCategory/Create

        public ActionResult Create()
        {
            return View();
        }

        //
        // POST: /CommentCategory/Create

        [HttpPost]
        public ActionResult Create(CommentCategory commentcategory)
        {
            if (ModelState.IsValid)
            {
                // Dodanie nowej kategorii komentarzy i zapisanie w bazie danych
                if (TryUpdateModel(commentcategory))
                {
                    _categoryRepo.Add(commentcategory);
                    _categoryRepo.SaveChanges();

                    TempData["Message"] = "Pomyślnie dodano kategorię!";
                    return RedirectToAction("Index");
                }
            }

            TempData["Error"] = "Wystąpił błąd podczas dodawania kategorii!";

            return View(commentcategory);
        }

        //
        // GET: /CommentCategory/Edit/5

        public ActionResult Edit(int id = 0)
        {
            // Pobranie kategorii komentarzy po identyfikatorze
            var commentcategory = _categoryRepo.GetCommentCategoryById(id);

            if (commentcategory != null)
            {
                return View(commentcategory);
            }
            else
            {
                TempData["Error"] = "Brak kategorii komentarza o podanym ID!";
                return RedirectToAction("Index");
            }
        }

        //
        // POST: /CommentCategory/Edit/5

        [HttpPost]
        public ActionResult Edit(int id, FormCollection collection)
        {
            // Pobranie kategorii komentarzy z bazy danych
            var categoryFromDataBase = _categoryRepo.GetCommentCategoryById(id);

            // Uaktualnienie modelu o nowe dane
            if (TryUpdateModel(categoryFromDataBase))
            {
                // Zapisanie zmian w bazie danych
                _categoryRepo.SaveChanges();
                TempData["Message"] = "Pomyślnie zmodyfikowano kategorię!";

                return RedirectToAction("Index");
            }
            else
            {
                TempData["Error"] = "Wystąpił błąd!";
                return View(categoryFromDataBase);
            }
        }
    }
}
