﻿using System.Web.Mvc;
using PortalUslug.Models;
using PortalUslug.Repositories;

namespace PortalUslug.Controllers
{
    [Authorize(Roles = "Administrator")]
    public class CategoryController : Controller
    {
        /// <summary>
        /// Repozytorium kategorii.
        /// </summary>
        private CategoryRepository _categoryRepo;

        /// <summary>
        /// Konstruktor kontrolera kategorii usług.
        /// </summary>
        public CategoryController()
        {
            // Inicjalizacja repozytorium
            _categoryRepo = new CategoryRepository();
        }

        //
        // GET: /Category/

        public ActionResult Index()
        {
            // Pobranie listy kategorii usług
            var categoriesList = _categoryRepo.GetAllCategories();
            return View(categoriesList);
        }

        //
        // GET: /Category/Create

        public ActionResult Create()
        {
            return View();
        }

        //
        // POST: /Category/Create

        [HttpPost]
        public ActionResult Create(Category category)
        {
            if (ModelState.IsValid)
            {
                // Dodanie nowej kategorii usług i zapisanie w bazie danych
                if (TryUpdateModel(category))
                {
                    _categoryRepo.Add(category);
                    _categoryRepo.SaveChanges();

                    TempData["Message"] = "Pomyślnie dodano kategorię!";
                    return RedirectToAction("Index");
                }
            }

            TempData["Error"] = "Wystąpił błąd podczas dodawania kategorii!";

            return View(category);
        }

        //
        // GET: /Category/Edit/5

        public ActionResult Edit(int id = 0)
        {
            // Pobranie kategorii usług po identyfikatorze
            var category = _categoryRepo.GetCategoryById(id);

            if (category != null)
            {
                return View(category);
            }
            else
            {
                TempData["Error"] = "Brak kategorii o podanym ID!";
                return RedirectToAction("Index");
            }
        }

        //
        // POST: /Category/Edit/5

        [HttpPost]
        public ActionResult Edit(int id, FormCollection collection)
        {
            /// Pobranie kategorii usług z bazy danych
            var categoryFromDataBase = _categoryRepo.GetCategoryById(id);

            // Uaktualnienie modelu o nowe dane
            if (TryUpdateModel(categoryFromDataBase))
            {
                // Zapisanie zmian w bazie danych
                _categoryRepo.SaveChanges();
                TempData["Message"] = "Pomyślnie zmodyfikowano kategorię!";

                return RedirectToAction("Index");
            }
            else
            {
                TempData["Error"] = "Wystąpił błąd!";
                return View(categoryFromDataBase);
            }
        }
    }
}
