﻿using System;
using System.Linq;
using PortalUslug.Models;

namespace PortalUslug.Repositories
{
    /// <summary>
    /// Interfejs repozytorium usługodawcy.
    /// </summary>
    public interface IServiceProviderRepository : IRepository<ServiceProvider>
    {
        /// <summary>
        /// Pobranie usługodawcy o podanym identyfikatorze usługodawcy.
        /// </summary>
        /// <param name="id">Identyfikator usługodawcy.</param>
        /// <returns>Usługodawca o podanym identyfikatorze usługodawcy.</returns>
        ServiceProvider GetServiceProviderById(int id);

        /// <summary>
        /// Pobranie usługodawcy o podanym identyfikatorze użytkownika.
        /// </summary>
        /// <param name="id">Identyfikator użytkownika.</param>
        /// <returns>Usługodawca o podanym identyfikatorze użytkownika.</returns>
        ServiceProvider GetServiceProviderByUserId(int id);

        /// <summary>
        /// Pobieranie usługodawców z potwierdzonym kontem.
        /// </summary>
        /// <returns>Usługodawcy z potwierdzonym kontem.</returns>
        IQueryable<ServiceProvider> GetServiceProviders();

        /// <summary>
        /// Pobieranie usługodawców z newsletterem.
        /// </summary>
        /// <returns>Usługodawcy z newsletterem.</returns>
        IQueryable<ServiceProvider> GetAllServiceProvidersWithNewsletter();

        /// <summary>
        /// Sprawdzenie, czy użytkownik o podanym identyfikatorze jest usługodawcą.
        /// </summary>
        /// <param name="id">Identyfikator użytkownika.</param>
        /// <returns>True, jeśli użytkownik o podanym identyfikatorze jest usługodawcą.</returns>
        bool IsServiceProvider(int id);

        /// <summary>
        /// Sprawdzenie, czy użytkownik o podanym identyfikatorze ma potwierdzone konto.
        /// </summary>
        /// <param name="id">Identyfikator użytkownika.</param>
        /// <returns>True, jeśli użytkownik o podanym identyfikatorze ma potwierdzone konto.</returns>
        bool IsConfirmed(int id);

        /// <summary>
        /// Pobranie wszystkich usługodawców.
        /// </summary>
        /// <returns>Usługodawcy.</returns>
        IQueryable<ServiceProviderViewModel> GetAllServiceProviders();
    }
}
