﻿using System;

namespace PortalUslug.Repositories
{
    /// <summary>
    /// Interfejs bazowy repozytorium.
    /// </summary>
    /// <typeparam name="T">Typ repozytorium.</typeparam>
    public interface IRepository<T>
    {
        /// <summary>
        /// Operacja dodawania.
        /// </summary>
        /// <param name="element">Dodawany obiekt.</param>
        void Add(T element);

        /// <summary>
        /// Operacja usuwania.
        /// </summary>
        /// <param name="element">Usuwany obiekt.</param>
        void Delete(T element);

        /// <summary>
        /// Zapisanie zmian.
        /// </summary>
        void SaveChanges();
    }
}