﻿using System.Collections.Generic;
using System.Linq;
using System.Web.Mvc;
using SerwisSubskrypcja.Helpers;
using SerwisSubskrypcja.Models;

namespace SerwisSubskrypcja.Controllers
{
    [Authorize(Roles = "Administrator")]
    public class NewsletterController : Controller
    {
        private SubscriptionContext _db = new SubscriptionContext();

        public NewsletterController()
        {
            _db = new SubscriptionContext();
        }

        public ActionResult Send()
        {
            return View();
        }

        [HttpPost]
        public ActionResult Send(Newsletter news)
        {
            if (ModelState.IsValid)
            {
                // Pobranie wszystkich subskrybentów
                var subscribers = _db.Subscribers;

                // Utworzenie listy adresów e-mail subskrybentów
                List<string> emails = subscribers.Select(u => u.Email).ToList();

                if (emails.Count > 0)
                {
                    // Wykorzystanie helpera do wysyłania e-maili
                    MailHelper.SendEmail(emails, news.Subject, news.Content);
                    return View("Sent");
                }
                else
                {
                    TempData["Error"] = "Brak aktywnych użytkowników. Newsletter nie został wysłany.";
                    return View();
                }
            }

            // W przypadku błędów zwrócenie aktualnego widoku
            return View(news);
        }
    }
}
