﻿function CartItemViewModel(params) {
    var self = this;

    self.sending = ko.observable(false);

    self.cartItem = params.cartItem;
    self.showButton = params.showButton;

    self.upsertCartItem = function (form) {
        if (!$(form).valid())
            return false;

        self.sending(true);

        var data = {
            id: self.cartItem.id,
            cartId: self.cartItem.cartId,
            bookId: self.cartItem.book.id,
            quantity: self.cartItem.quantity()
        };

        $.ajax({
            url: '/api/cartitems',
            type: self.cartItem.id === undefined ? 'post' : 'put',
            contentType: 'application/json',
            data: ko.toJSON(data)
        })
        .success(self.successfulSave)
        .error(self.errorSave)
        .complete(function () { self.sending(false) });
    };

    self.successfulSave = function (data) {
        var msg = '<div class="alert alert-success"><strong>Powodzenie!</strong> Pozycja została ';
        if (self.cartItem.id === undefined)
            msg += 'dodana';
        else
            msg += 'zaktualizowana';

        $('.body-content').prepend(msg + ' do koszyka/w koszyku.</div>');

        self.cartItem.id = data.id;

        cartSummaryViewModel.updateCartItem(ko.toJS(self.cartItem));
    };

    self.errorSave = function () {
        var msg = '<div class="alert alert-danger"><strong>Błąd!</strong> Wystąpił błąd podczas ';
        if (self.cartItem.id === undefined)
            msg += 'dodawania';
        else
            msg += 'aktualizowania';

        $('.body-content').prepend(msg + ' pozycji koszyka.</div>');
    };
};

ko.components.register('upsert-cart-item', {
    viewModel: CartItemViewModel,
    template: { element: 'cart-item-form' }
});