Imports System.IO
Imports System.Xml
Imports System.Xml.XPath

Partial Class _Default
    Inherits System.Web.UI.Page

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) _
           Handles Me.Load
        ' Wczytaj dokument
        Dim booksFile As String = Server.MapPath("books.xml")

        Dim document As New XmlDocument()
        document.Load(booksFile)
        Dim nav As XPathNavigator = document.CreateNavigator()

        ' Dodaj prefiks przestrzeni nazw, aby mg by wykorzystany w wyraeniu XPath
        Dim namespaceMgr As New XmlNamespaceManager(nav.NameTable)
        namespaceMgr.AddNamespace("b", "http://example.books.com")

        ' Wszystkie ksiki, ktrych cena nie jest wiksza ni 10.00
        For Each node As XPathNavigator In nav.Select( _
                "//b:book[not(b:price[. > 10.00])]/b:price", namespaceMgr)
            Dim price As Decimal = CType(node.ValueAs(GetType(Decimal)), Decimal)
            node.SetTypedValue(price * CDec(1.2))
            Response.Write(String.Format("Cena wzrosa z {0} do {1}<BR/>", _
              price, _
              CType(node.ValueAs(GetType(Decimal)), Decimal)))
        Next


    End Sub

End Class
