using System;
using System.IO;
using System.Xml;
using System.Xml.XPath;

public partial class _Default : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        // Wczytaj dokument
        string booksFile = Server.MapPath("books.xml");

        XPathDocument document = new XPathDocument(booksFile);
        XPathNavigator nav = document.CreateNavigator();

        // Dodaj prefiks przestrzeni nazw, aby mg by wykorzystany w wyraeniu XPath
        XmlNamespaceManager namespaceMgr = new XmlNamespaceManager(nav.NameTable);
        namespaceMgr.AddNamespace("b", "http://example.books.com");

        // Wszystkie ksiki, ktrych cena nie jest wiksza ni 10.00
        foreach (XPathNavigator node in
            nav.Select("//b:book[not(b:price[. > 10.00])]/b:price",
            namespaceMgr))
        {
            Decimal price = (decimal)node.ValueAs(typeof(decimal));
            Response.Write(String.Format("Cena wynosi {0}<BR/>",
                price));
        }
    }

}
