﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;

namespace AppendixCCS
{
    public partial class App : Application
    {

        public App()
        {
            this.Startup += this.Application_Startup;
            this.Exit += this.Application_Exit;
            this.UnhandledException += this.Application_UnhandledException;

            InitializeComponent();
        }

        private void Application_Startup(object sender, StartupEventArgs e)
        {
            this.RootVisual = new MainPage();
        }

        //**** LISTING C-7 ****
        //private void Application_Startup(object sender, StartupEventArgs e)
        //{
        //    switch (e.InitParams["DefaultStartPoint"])
        //    {
        //        case "Customer":
        //            this.RootVisual = new Customer();
        //            break;
        //        case "Order":
        //            this.RootVisual = new Order();
        //            break;
        //        default:
        //            this.RootVisual = new Home();
        //            break;
        //    }
        //}

        //**** LISTING C-12 ****
        //private void Application_Startup(object sender, StartupEventArgs e)
        //{
        //    this.RootVisual = new MainPage();

        //    ListingC_11 employee = new ListingC_11();
        //    System.Windows.Browser.HtmlPage.RegisterScriptableObject("Employee", employee);
        //}


        //private void Application_Startup(object sender, StartupEventArgs e)
        //{
        //    this.RootVisual = new MainPage();
        //    System.Windows.Browser.HtmlPage.RegisterCreateableType("Employee", typeof(ListingC_14));
        //}

        private void Application_Exit(object sender, EventArgs e)
        {

        }
        private void Application_UnhandledException(object sender, ApplicationUnhandledExceptionEventArgs e)
        {
            // Jeśli aplikacja działa poza debugerem, należy zgłosić wyjątek za pomocą
            // mechanizmów z przeglądarki. W IE spowoduje to wyświetlenie żółtej ikony 
            // w pasku statusu; w Firefoksie pojawi się błąd skryptu.
            if (!System.Diagnostics.Debugger.IsAttached)
            {

                // UWAGA: umożliwia to aplikacji kontynuowanie działania po zgłoszeniu wyjątku, który
                // nie został obsłużony. 
                // W aplikacjach produkcyjnych tę obsługę błędów należy zastąpić kodem,
                // który zgłosi błąd w witrynie i zatrzyma aplikację.
                e.Handled = true;
                Deployment.Current.Dispatcher.BeginInvoke(delegate { ReportErrorToDOM(e); });
            }
        }
        private void ReportErrorToDOM(ApplicationUnhandledExceptionEventArgs e)
        {
            try
            {
                string errorMsg = e.ExceptionObject.Message + e.ExceptionObject.StackTrace;
                errorMsg = errorMsg.Replace('"', '\'').Replace("\r\n", @"\n");

                System.Windows.Browser.HtmlPage.Window.Eval("throw new Error(\"Nieobsłużony błąd w aplikacji Silverlight 2 " + errorMsg + "\");");
            }
            catch (Exception)
            {
            }
        }
    }
}
