<%@ Language = VBSCRIPT %>
<% Option Explicit %>

<%
   '*************************************************
   'Wywietlenie kalendarza na podstawie aktualnej daty
   '*************************************************

   'Aby zeralizowa zadanie, bdziemy musieli wykona kilka czynnoci.
   'Po pierwsze, musimy okreli nazw aktualnego miesica.
   'A zatem stwrzmy funkcj, ktra pobiera numer miesica 
   'i wywietla jego nazw. Np.: GetMonthName(8) da 
   'warto Sierpie
   Function GetMonthName(iMonth)
     Select Case iMonth
        Case 1:
          GetMonthName = "January"
        Case 2:
          GetMonthName = "February"
        Case 3:
          GetMonthName = "March"
        Case 4:
          GetMonthName = "April"
        Case 5:
          GetMonthName = "May"
        Case 6:
          GetMonthName = "June"
        Case 7:
          GetMonthName = "July"
        Case 8:
          GetMonthName = "August"
        Case 9:
          GetMonthName = "September"
        Case 10:
          GetMonthName = "October"
        Case 11:
          GetMonthName = "November"
        Case 12:
          GetMonthName = "December"
        Case Else:
          GetMonthName = "**INVALID MONTH**"
     End Select
   End Function


   'Teraz musimy pobra dat przesan w acuchu zapytania.
   'W tym celu odczytamy zmienn Date z kolekcji QueryString
   'obiektu Request.
   Dim dbCurrentDate
   dbCurrentDate = Request("Date")

   'Teraz stworzymy cookie, abymy mogli zapamita ostatnio przegldany
   'miesic. Jeli data zostaa podana, to ustawiamy warto cookie, w 
   'przeciwnym przypadku odczytujemy warto cookie aby okreli dla jakiej 
   'daty uytkownik chce sporzdzi kalendarz. Jeli adna data nie zostaa
   'przesana to Len(dbCurrentDate) = 0, gdy dbCurrentDate zawiera pusty
   'acuch znakw
   If Len(dbCurrentDate) = 0 then
     'Odczytujemy warto cookie
     dbCurrentDate = Request.Cookies("CalendarDate")
   End If

   'Upewnijmy si czy w dbCurrentDate jest jaka warto. Jeli warto nie
   'zostaa przesana w acuchu zapytania ani okrelona na podstawie cookie,
   'to dbCurrentDate bdzie zawieraa pusty acuch znakw.
   If Len(dbCurrentDate) = 0 then
     'Data nie zostaa przesana za porednictwem acucha zapytania
     'zapisujemy w zmiennej dbCurrentDate aktualn dat systemow
     dbCurrentDate = Date()
   End If

   'Teraz ju wiemy, e w zmiennej dbCurrentDate zapisana jest poprawna data.
   'Jeli data nie zostaa przekazana w acuchu zapytania, to okrelilimy j
   'na podstawie cookie przechowywanego na komputerze uytkownika; 
   'data ta reprezentuje ostatni dat wywietlon w kalendarzu. 
   'Jeli nie byo cookie, to w zmiennej dbCurrentDate zapisalimy aktualn 
   'dat systemow. Teraz tworzymy cookie o wartoci dbCurrentDate
   Response.Cookies("CalendarDate") = dbCurrentDate

   'Data wanoci cookie mija za 30 dni
   Response.Cookies("CalendarDate").Expires = Now() + 30


   'Teraz kiedy ju okrelilimy dat w miesicu ktry chcemy 
   'wywietli na kalendarzu, musimy pobra z bazy danych wszystkie
   'zdarzenia zaplanowane na ten miesic. 
   'Rozpoczniemy od stworzenia egzemplarza obiektu Connection.
   Dim objConn
   Set objConn = Server.CreateObject("ADODB.Connection")
   objConn.ConnectionString = "DSN=CalendarEvents"
   objConn.Open

   'Teraz musimy stworzy egzemplarz obiektu Recordset i pobra wszystkie
   'zdarzenia, w ktrych kolumna Month ma warto Month(dbCurrentDate)
   'a kolumna Year warto Year(dbCurrentDate). W tym celu stworzymy
   'odpowiednie polecenie SQL, gdy w tabeli Event moe by wiele
   'rekordw speniajcych te warunki.
   Dim strSQL
   strSQL = "SELECT Day, EventTitle FROM Event WHERE Month = " & _
            Month(dbCurrentDate) & " AND Year = " & Year(dbCurrentDate) & _
            " ORDER BY Day ASC"

   'Teraz musimy stworzy i otworzy egzemplarz obiektu Recordset. Uyjemy
   'domylnego kursora jednokierunkowego pozwalajcego tylko na odczyt
   'danych.
   Dim objRS
   Set objRS = Server.CreateObject("ADODB.Recordset")
   objRS.Open strSQL, objConn

   'Teraz bdziemy musieli wywietli kalendarz. Kalendarz 
   'moe obejmowa co najwyej sze tygodni.Kady tydzie ma 
   '7 dni, a zatem bdziemy musieli wywietli co najwyej
   '42 komrki tabeli. Kalendarz wygenerujemy przy wykorzystaniu
   'znacznika TABLE.

   'Teraz stworzymy tablic, ktra bdzie zawieraa 42 moliwe
   'dni kalendarza.
   Dim aCalendarDays(42)

   'W tablicy aCalendarDays zapiszemy dni aktualnego miesica.
   'Do okrelenia miejsca, gdzie powinien by zapisany pierwszy 
   'dzie miesica uyjemy funkcji DatePart.
   Dim iFirstWeekday
   iFirstWeekday = DatePart("w",DateSerial(Year(dbCurrentDate), Month(dbCurrentDate), 1))

   'Teraz, w ptli, przeanalizujemy wszystkie dni aktualnego
   'miesica i zapiszemy odpowiednie informacje w tablicy aCalendarDays.
   Dim iDaysInMonth
   iDaysInMonth = DatePart("d",DateSerial(Year(dbCurrentDate), Month(dbCurrentDate)+1, 1-1))
   Dim iLoop
   For iLoop = 1 to iDaysInMonth
      aCalendarDays(iLoop + iFirstWeekday - 1) = iLoop
   Next


   'Teraz, gdy ju zapisalimy potrzebne informacje w tablicy,
   'musimy wywietli j w formie kalendarza. Nasza tabela bdzie
   'miaa 7 kolumn - po jednej dla kadego dnia tygodnia. 
   'Wywietlajc tabel uyjemy 6 wierszy (maksymalnej moliwej 
   'iloci wierszy) minus 42 (grna granica tablicy aCalendarDays)
   'minus numer ostatniej uytej komrki (iFirstWeekday + iDaysInMonth)
   'podzielene przez 7 (ilo dni tygodnia). Proste, nieprawda?!
   Dim iColumns, iRows
   iColumns = 7
   iRows = 6 - Int((42 - (iFirstWeekDay + iDaysInMonth)) / 7)


   'Zapamitujemy daty przyszego i poprzedniego miesica, kodujc je
   'przy uyciu metody Server.URLEncode, dziki czemu bdziemy mogli
   'bezpiecznie przesa je za porednictwem acucha zapytania
   Dim strPrevMonth, strNextMonth
   strPrevMonth = Server.URLEncode(DateAdd("m", -1, dbCurrentDate))
   strNextMonth = Server.URLEncode(DateAdd("m", 1, dbCurrentDate))

   'Teraz tworzymy tabel
%>

<HTML>
<BODY>
   <TABLE ALIGN=CENTER BORDER=1 CELLSPACING=1 WIDTH=75% HEIGHT=75%>
   <TR>
     <TH>
        <A HREF="Kalendarz.asp?Date=<%=strPrevMonth%>">
             Wywietl kalendarz na poprzedni miesic
        </A>
     </TH>

     <TH COLSPAN=5>
        <FONT SIZE=+2>
<%
   'Wywietlamy miesic i rok
   Response.Write GetMonthName(Month(dbCurrentDate))
   Response.Write ", " & Year(dbCurrentDate)
%>
        </FONT>
     </TH>

     <TH>
        <A HREF="Kalendarz.asp?Date=<%=strNextMonth%>">
             Wywietl kalendarz na nastpny miesic
        </A>
     </TH>
    </TR>

<%
   'Tworzymy zmienn, suc do obliczenia iloci rekordw
   Dim iEventCount
   iEventCount = 0

   'Ptle od 1 do iRows oraz od 1 do iColumns
   Dim iRowsLoop, iColumnsLoop
   For iRowsLoop = 1 to iRows
     'Tworzymy nowy wiersz
     Response.Write "<TR>"
     For iColumnsLoop = 1 to iColumns
       'Tworzymy now kolumn
       'Jeli jest dzie to wywietlamy go.
       If aCalendarDays((iRowsLoop-1)*7 + iColumnsLoop) > 0 then
         'Wywietlamy dat i okrelamy czy w bazie jest zdarzenie
         'skojarzone skojarzone z t dat
         Response.Write "<TD VALIGN=TOP ALIGN=RIGHT WIDTH=14% " & _
                         "HEIGHT=" & FormatPercent(1/iRows,0) & ">"
         Response.Write "<TABLE CELLSPACING=0 CELLPADDING=0 BORDER=0 " & _
                        "WIDTH=""100%"">"

         'Wywietlamy dzie w prawym grnym roku
         Response.Write "<TR><TD ALIGN=RIGHT><B>"
         Response.Write aCalendarDays((iRowsLoop-1)*7 + iColumnsLoop)
         Response.Write "</B></TD></TR>"

         'Wywietlamy zdarzenie skojarzone z danym dniem, jeli istnieje
         'Najpierw sprawdzamy czy s rekordy w zmiennej objRS
         If Not objRS.EOF then
            'Teraz sprawdzamy czy aktualny rekord zawiera dat
            'odpowiadjc dacie wywietlanego dnia
            If objRS("Day") = aCalendarDays((iRowsLoop-1)*7 + iColumnsLoop) then
               Response.Write "<TR><TD VALIGN=TOP ALIGN=LEFT>"
               Response.Write "<FONT SIZE=2>"

               Response.Write objRS("EventTitle")
               objRS.MoveNext

               'Inkrementujemy ilo wywietlonych zdarze
               iEventCount = iEventCount + 1

               Response.Write "</FONT>"
               Response.Write "</TD></TR>"
            End If
         End If
         
         Response.Write "</TABLE>"
         Response.Write "</TD>"
       Else
         'Brak dnia - komrka na czarno
         Response.Write "<TD BGCOLOR=BLACK>&nbsp;</TD>"
       End If
     Next

     'Zamykamy wiersz
     Response.Write "</TR>"
   Next

   'Zamykamy i jawnie usuwamy z pamici egzemplarze obiektw
   'Recordset i Connection
   objRS.Close
   Set objRS = Nothing

   objConn.Close
   Set objConn = Nothing
%>

   </TABLE>

   <CENTER>
   <FONT SIZE=2>
      <%=GetMonthName(Month(dbCurrentDate))%> <%=Year(dbCurrentDate)%>
      - <%=FormatNumber(iEventCount,0)%> zdarze.
   </FONT>
   </CENTER>

   <P>
   <FORM METHOD=GET ACTION="Kalendarz.asp">
     <CENTER><B>Wywietl kalendarz na miesic</B><BR>
     <SELECT SIZE=1 NAME=Date>
        <OPTION VALUE="<%=DateSerial(Year(dbCurrentDate), 1, 1)%>"
          <% If Month(dbCurrentDate) = 1 then Response.Write " SELECTED" %>>
           January
        </OPTION>
        <OPTION VALUE="<%=DateSerial(Year(dbCurrentDate), 2, 1)%>"
          <% If Month(dbCurrentDate) = 2 then Response.Write " SELECTED" %>>
           February
        </OPTION>
        <OPTION VALUE="<%=DateSerial(Year(dbCurrentDate), 3, 1)%>"
          <% If Month(dbCurrentDate) = 3 then Response.Write " SELECTED" %>>
           March
        </OPTION>
        <OPTION VALUE="<%=DateSerial(Year(dbCurrentDate), 4, 1)%>"
          <% If Month(dbCurrentDate) = 4 then Response.Write " SELECTED" %>>
           April
        </OPTION>
        <OPTION VALUE="<%=DateSerial(Year(dbCurrentDate), 5, 1)%>"
          <% If Month(dbCurrentDate) = 5 then Response.Write " SELECTED" %>>
           May
        </OPTION>
        <OPTION VALUE="<%=DateSerial(Year(dbCurrentDate), 6, 1)%>"
          <% If Month(dbCurrentDate) = 6 then Response.Write " SELECTED" %>>
           June
        </OPTION>
        <OPTION VALUE="<%=DateSerial(Year(dbCurrentDate), 7, 1)%>"
          <% If Month(dbCurrentDate) = 7 then Response.Write " SELECTED" %>>
           July
        </OPTION>
        <OPTION VALUE="<%=DateSerial(Year(dbCurrentDate), 8, 1)%>"
          <% If Month(dbCurrentDate) = 8 then Response.Write " SELECTED" %>>
           August
        </OPTION>
        <OPTION VALUE="<%=DateSerial(Year(dbCurrentDate), 9, 1)%>"
          <% If Month(dbCurrentDate) = 9 then Response.Write " SELECTED" %>>
           September
        </OPTION>
        <OPTION VALUE="<%=DateSerial(Year(dbCurrentDate), 10, 1)%>"
          <% If Month(dbCurrentDate) = 10 then Response.Write " SELECTED" %>>
           October
        </OPTION>
        <OPTION VALUE="<%=DateSerial(Year(dbCurrentDate), 11, 1)%>"
          <% If Month(dbCurrentDate) = 11 then Response.Write " SELECTED" %>>
           November
        </OPTION>
        <OPTION VALUE="<%=DateSerial(Year(dbCurrentDate), 12, 1)%>"
          <% If Month(dbCurrentDate) = 12 then Response.Write " SELECTED" %>>
           December
        </OPTION>
      </SELECT>
      <BR>
      <INPUT TYPE=SUBMIT VALUE="View Select Month">
    </FORM>
    </CENTER>
</BODY>
</HTML>