<%@ Language = VBSCRIPT %>
<% Option Explicit %>

<HTML>
<BODY>

<%
   '*************************************************
   'Wywietlenie kalendarza na podstawie aktualnej daty
   '*************************************************

   'Aby zeralizowa zadanie, bdziemy musieli wykona kilka czynnoci.
   'Po pierwsze, musimy okreli nazw aktualnego miesica.
   'A zatem stwrzmy funkcj, ktra pobiera numer miesica 
   'i wywietla jego nazw. Np.: GetMonthName(8) zwrci Sierpi
   Function GetMonthName(iMonth)
     Select Case iMonth
        Case 1:
          GetMonthName = "Stycze"
        Case 2:
          GetMonthName = "Luty"
        Case 3:
          GetMonthName = "Marzec"
        Case 4:
          GetMonthName = "Kwiecie"
        Case 5:
          GetMonthName = "Maj"
        Case 6:
          GetMonthName = "Czerwiec"
        Case 7:
          GetMonthName = "Lipiec"
        Case 8:
          GetMonthName = "Sierpie"
        Case 9:
          GetMonthName = "Wrzesie"
        Case 10:
          GetMonthName = "Padziernik"
        Case 11:
          GetMonthName = "Listopad"
        Case 12:
          GetMonthName = "Grudze"
        Case Else:
          GetMonthName = "**NIEWACIWYCH MIESIC**"
     End Select
   End Function


   'Teraz musimy okreli aktualn dat.
   'W tym celu zapiszemy wyniki wykonania funkcji Date()
   'w zmiennej cbCurrentDate
   Dim dbCurrentDate
   'dbCurrentDate = Date()
   dbCurrentDate = "1/1/2000"

   'Teraz bdziemy musieli wywietli kalendarz. Kalendarz 
   'moe obejmowa co najwyej sze tygodni.Kady tydzie ma 
   '7 dni, a zatem bdziemy musieli wywietli co najwyej
   '42 komrki tabeli. Kalendarz wygenerujemy przy wykorzystaniu
   'znacznika TABLE.

   'Teraz stworzymy tablic, ktra bdzie zawieraa 42 moliwe
   'dni kalendarza.
   Dim aCalendarDays(42)

   'W tablicy aCalendarDays zapiszemy dni aktualnego miesica.
   'Do okrelenia miejsca, gdzie powinien by zapisany pierwszy 
   'dzie miesica uyjemy funkcji DatePart.
   Dim iFirstWeekday
   iFirstWeekday = DatePart("w",DateSerial(Year(dbCurrentDate), Month(dbCurrentDate), 1))

   'Teraz, w ptli, przeanalizujemy wszystkie dni aktualnego
   'miesica i zapiszemy odpowiednie informacje w tablicy aCalendarDays.
   Dim iDaysInMonth
   iDaysInMonth = DatePart("d",DateSerial(Year(dbCurrentDate), Month(dbCurrentDate)+1, 1-1))
   Dim iLoop
   For iLoop = 1 to iDaysInMonth
      aCalendarDays(iLoop + iFirstWeekday - 1) = iLoop
   Next


   'Teraz, gdy ju zapisalimy potrzebne informacje w tablicy,
   'musimy wywietli j w formie kalendarza. Nasza tabela bdzie
   'miaa 7 kolumn - po jednej dla kadego dnia tygodnia. 
   'Wywietlajc tabel uyjemy 6 wierszy (maksymalnej moliwej 
   'iloci wierszy) minus 42 (grna granica tablicy aCalendarDays)
   'minus numer ostatniej uytej komrki (iFirstWeekday + iDaysInMonth)
   'podzielene przez 7 (ilo dni tygodnia). Proste, nieprawda?!
   Dim iColumns, iRows
   iColumns = 7
   iRows = 6 - Int((42 - (iFirstWeekDay + iDaysInMonth)) / 7)

   'Teraz tworzymy tabel
%>

   <TABLE ALIGN=CENTER BORDER=1 CELLSPACING=1 WIDTH=75% HEIGHT=75%>
     <TH COLSPAN=7>
        <FONT SIZE=+2>
<%
   'Wywietl nazw miesica i rok
   Response.Write GetMonthName(Month(dbCurrentDate))
   Response.Write ", " & Year(dbCurrentDate)
%>
        </FONT>
     </TH>
<%
   'Ptle tworzce kalendarz
   Dim iRowsLoop, iColumnsLoop
   For iRowsLoop = 1 to iRows
     'Tworzymy nowy wiersz tablicy
     Response.Write "<TR>"
     For iColumnsLoop = 1 to iColumns
       'Tworzymy now kolumn
       'Jeli jest dzie to go wywietlamy, jeli nie ma - wypeniamy komrk na czarno
       If aCalendarDays((iRowsLoop-1)*7 + iColumnsLoop) > 0 then
         'Wywietlamy dat
         Response.Write "<TD VALIGN=TOP ALIGN=RIGHT WIDTH=""14%"">"
         Response.Write aCalendarDays((iRowsLoop-1)*7 + iColumnsLoop)
         Response.Write "</TD>"
       Else
         'Wypeniamy komrk na czarno
         Response.Write "<TD BGCOLOR=BLACK>&nbsp;</TD>"
       End If
     Next

     'Zamykamy wiersz
     Response.Write "</TR>"
   Next
%>

   </TABLE>
</BODY>
</HTML> 