﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="Transactions.aspx.cs" Inherits="Transactions" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
   <title>Transakcje</title>
</head>
<body>
   <form id="form1" runat="server">
   <div>
      <asp:GridView ID="OrdersGridView" runat="server" DataKeyNames="SalesOrderID" OnSelectedIndexChanged="OrdersGridView_SelectedIndexChanged"
         AutoGenerateColumns="False">
         <Columns>
            <asp:ButtonField ButtonType="Button"
               CommandName="Select" Text="Szczegóły" />
            <asp:BoundField DataField="SalesOrderID" HeaderText="ID zamówienia" />
            <asp:BoundField DataField="OrderDate" HeaderText="Data zamówienia" />
            <asp:BoundField DataField="CompanyName" HeaderText="Firma" />
            <asp:BoundField DataField="ContactName" HeaderText="Kontakt" />
            <asp:BoundField DataField="Phone" HeaderText="Telefon" />
            <asp:BoundField DataField="PurchaseOrderNumber"
               HeaderText="Numer zamówienia #" />
         </Columns>
      </asp:GridView>
      <asp:Panel ID="OrderDetailsPanel" runat="server" Visible="false">
         <asp:DetailsView ID="OrderDetailsView" runat="server" AutoGenerateRows="False">
            <Fields>
               <asp:BoundField DataField="ProductName" HeaderText="Produkt" />
               <asp:BoundField DataField="UnitPrice" HeaderText="Cena jednostkowa" />
               <asp:BoundField DataField="OrderQty" HeaderText="Ilość" />
            </Fields>
         </asp:DetailsView>
      </asp:Panel>
      <h3>
         Złóż nowe zamówienie</h3>
      <table>
         <tr>
            <td>
               Firma:
            </td>
            <td>
               <asp:DropDownList ID="ddlCompany" DataValueField="CustomerID" DataTextField="CompanyName"
                  Width="160" runat="server" />
            </td>
            <td>
               Produkt:
            </td>
            <td>
               <asp:DropDownList ID="ddlProduct" runat="server" DataValueField="ProductID" DataTextField="Name"
                  Width="160" />
            </td>
            <td>
            </td>
            <td>
            </td>
         </tr>
         <tr>
            <td>
               Cena jednostkowa:
            </td>
            <td>
               <asp:TextBox ID="txtUnitPrice" runat="server" Width="48px" Text="0" />
            </td>
            <td>
               Ilość:
            </td>
            <td>
               <asp:TextBox ID="txtQuantity" runat="server" Width="48px" Text="0" />
            </td>
            <td>
               Rabat:
            </td>
            <td>
               <asp:TextBox ID="txtDiscount" runat="server" Width="48px" Text="0" />
            </td>
         </tr>
         <tr>
            <td colspan="4">
               <asp:RadioButtonList ID="rbTransactionType" runat="server" RepeatDirection="Horizontal">
                  <asp:ListItem Value="DB" Selected="true">Transakcja bazy danych</asp:ListItem>
                  <asp:ListItem Value="Connection">Transakcja na podstawie połączenia</asp:ListItem>
               </asp:RadioButtonList>
            </td>
            <td>
               <asp:Button ID="btnAdd" runat="server" Text="Dodaj" OnClick="btnAdd_Click" />
            </td>
            <td>
               <asp:Label ID="lblNewOrderID" runat="server" Text="" />
            </td>
         </tr>
      </table>
   </div>
   </form>
</body>
</html>
