﻿using System;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;

public partial class DisplayModeMenu : UserControl
{

   // Używamy odniesienia do bieżącej kontrolki WebPartManager.        
   WebPartManager webPartManager;

   public void Page_Init(object sender, EventArgs e)
   {
      Page.InitComplete += new EventHandler(InitComplete);
   }

   // Gdy strona zostanie w pełni zainicjalizowana.       
   public void InitComplete(object sender, EventArgs e)
   {
      webPartManager = WebPartManager.GetCurrentWebPartManager(Page);
      String browseModeName = WebPartManager.BrowseDisplayMode.Name;
      foreach (WebPartDisplayMode mode in webPartManager.SupportedDisplayModes)
      {
         String modeName = mode.Name;
         if (mode.IsEnabled(webPartManager))
         {
            ListItem listItem = new ListItem(modeName, modeName);
            ddlDisplayMode.Items.Add(listItem);
         }
      }
   }

   // Zmieniamy tryb wyświetlania strony na zaznaczony.      
   public void ddlDisplayMode_SelectedIndexChanged(object sender, EventArgs e)
   {
      String selectedMode = ddlDisplayMode.SelectedValue;
      WebPartDisplayMode mode = webPartManager.SupportedDisplayModes[selectedMode];
      if (mode != null)
      {
         webPartManager.DisplayMode = mode;
      }
   }

   // Ustawiamy zaznaczone elementy identycznie z bieżącym trybem wyświetlania.      
   public void Page_PreRender(object sender, EventArgs e)
   {
      ListItemCollection items = ddlDisplayMode.Items;
      int selectedIndex = items.IndexOf(items.FindByText(webPartManager.DisplayMode.Name));
      ddlDisplayMode.SelectedIndex = selectedIndex;
   }
}

