﻿using System.Web.UI;
using System.Web.UI.WebControls;

public partial class GridViewCustomRows : Page
{
   protected void gvwCustomers_RowEditing(object sender, GridViewEditEventArgs e)
   {
      SwitchVisibleColumns(false);
   }

   protected void gvwCustomers_RowCancelingEdit(object sender, GridViewCancelEditEventArgs e)
   {
      SwitchVisibleColumns(true);
   }

   protected void gvwCustomers_RowUpdated(object sender, GridViewUpdatedEventArgs e)
   {
      SwitchVisibleColumns(true);
   }
   
   private void SwitchVisibleColumns(bool inReadOnlyMode)
   {
      gvwCustomers.Columns[1].Visible = inReadOnlyMode;   // Pole FullName.
      gvwCustomers.Columns[2].Visible = !inReadOnlyMode;  // Pole NameStyle.
      gvwCustomers.Columns[3].Visible = !inReadOnlyMode;  // Pole Title.
      gvwCustomers.Columns[4].Visible = !inReadOnlyMode;  // Pole FirstName.
      gvwCustomers.Columns[5].Visible = !inReadOnlyMode;  // Pole MiddleName.
      gvwCustomers.Columns[6].Visible = !inReadOnlyMode;  // Pole LastName.
      gvwCustomers.Columns[7].Visible = !inReadOnlyMode;  // Pole Suffix.
      gvwCustomers.Columns[12].Visible = inReadOnlyMode;  // Pole ModifiedDate.
      gvwCustomers.Columns[13].Visible = inReadOnlyMode;  // Pole PasswordHash.
      gvwCustomers.Columns[14].Visible = inReadOnlyMode;  // Pole PasswordSalt.
   }


}
