﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="DetailsViewCustomRows.aspx.cs"
   Inherits="DetailsViewCustomRows" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
   <title>Kontrolka DetailsView</title>
</head>
<body>
   <form id="form1" runat="server">
   <div>
      <asp:SqlDataSource ID="dsCustomers" runat="server" ConnectionString="<%$ ConnectionStrings:AWLTConnection %>"
         SelectCommand="SELECT	[CustomerID], [NameStyle],
	CASE WHEN [Title] IS NULL THEN '' ELSE [Title] + ' ' END +
    [FirstName] + ' ' +
	CASE WHEN [MiddleName] IS NULL THEN '' ELSE [MiddleName] + ' ' END +
	[LastName] + 
	CASE WHEN [Suffix] IS NULL THEN '' ELSE ' ' + [Suffix] END as 'FullName',
	[Title], [FirstName], [MiddleName], [LastName], [Suffix],
	[CompanyName], [SalesPerson], [ModifiedDate], [EmailAddress], [Phone], 
	[PasswordHash], [PasswordSalt]
FROM [SalesLT].[Customer]"
      InsertCommand="INSERT INTO [SalesLT].[Customer] ([NameStyle], [Title], [FirstName], [MiddleName], [LastName], [Suffix], [CompanyName], [SalesPerson], [EmailAddress], [Phone], [PasswordHash], [PasswordSalt]) VALUES (@NameStyle, @Title, @FirstName, @MiddleName, @LastName, @Suffix, @CompanyName, @SalesPerson, @EmailAddress, @Phone, @PasswordHash, @PasswordSalt)"
      UpdateCommand="UPDATE [SalesLT].[Customer] SET [NameStyle] = @NameStyle, [Title] = @Title, [FirstName] = @FirstName, [MiddleName] = @MiddleName, [LastName] = @LastName, [Suffix] = @Suffix, [CompanyName] = @CompanyName, [SalesPerson] = @SalesPerson, [EmailAddress] = @EmailAddress, [Phone] = @Phone, [ModifiedDate] = GetDate() WHERE [CustomerID] = @CustomerID">
      <UpdateParameters>
         <asp:Parameter Name="NameStyle" Type="Boolean" />
         <asp:Parameter Name="Title" Type="String" />
         <asp:Parameter Name="FirstName" Type="String" />
         <asp:Parameter Name="MiddleName" Type="String" />
         <asp:Parameter Name="LastName" Type="String" />
         <asp:Parameter Name="Suffix" Type="String" />
         <asp:Parameter Name="CompanyName" Type="String" />
         <asp:Parameter Name="SalesPerson" Type="String" />
         <asp:Parameter Name="EmailAddress" Type="String" />
         <asp:Parameter Name="Phone" Type="String" />
         <asp:Parameter Name="CustomerID" Type="Int32" />
      </UpdateParameters>
      <InsertParameters>
         <asp:Parameter Name="NameStyle" Type="Boolean" />
         <asp:Parameter Name="Title" Type="String" />
         <asp:Parameter Name="FirstName" Type="String" />
         <asp:Parameter Name="MiddleName" Type="String" />
         <asp:Parameter Name="LastName" Type="String" />
         <asp:Parameter Name="Suffix" Type="String" />
         <asp:Parameter Name="CompanyName" Type="String" />
         <asp:Parameter Name="SalesPerson" Type="String" />
         <asp:Parameter Name="EmailAddress" Type="String" />
         <asp:Parameter Name="Phone" Type="String" />
         <asp:Parameter Name="PasswordHash" Type="String" />
         <asp:Parameter Name="PasswordSalt" Type="String" />
      </InsertParameters>
</asp:SqlDataSource>
      <asp:DetailsView ID="dvwCustomers" runat="server" AllowPaging="True" 
         AutoGenerateRows="False" DataSourceID="dsCustomers" onmodechanged="dvwCustomers_ModeChanged" 
         DataKeyNames="CustomerID" oniteminserting="dvwCustomers_ItemInserting">
         <PagerSettings FirstPageText="Pierwsza" LastPageText="Ostatnia" PageButtonCount="5" />
         <EmptyDataTemplate>
            No customers found I&#39;m afraid
         </EmptyDataTemplate>
         <Fields>
            <asp:BoundField DataField="CustomerID" ReadOnly="True" Visible="False" />
            <asp:BoundField DataField="FullName" HeaderText="Imię i nazwisko" ReadOnly="true" />
            <asp:CheckBoxField HeaderText="Nazwisko inne niż zachodnie?" DataField="NameStyle" Visible="false" />
            <asp:BoundField DataField="Title" HeaderText="Tytuł" Visible="false" />
            <asp:BoundField DataField="FirstName" HeaderText="Imię" Visible="false" />
            <asp:BoundField DataField="MiddleName" HeaderText="Drugie imię" Visible="false" />
            <asp:BoundField DataField="LastName" HeaderText="Nazwisko" Visible="false" />
            <asp:BoundField DataField="Suffix" HeaderText="Przyrostek" Visible="false" />
            <asp:BoundField DataField="CompanyName" HeaderText="Firma" />
            <asp:TemplateField HeaderText="Email Address">
               <ItemTemplate>
                  <asp:HyperLink ID="hypEmailReadOnly" runat="server" 
                     NavigateUrl='<%# Eval("EmailAddress", "mailto:{0}") %>' 
                     Text='<%# Eval("EmailAddress") %>'></asp:HyperLink>
               </ItemTemplate>
               <EditItemTemplate>
                  <asp:TextBox ID="txtEmailEdit" runat="server" 
                     Text='<%# Bind("EmailAddress") %>' />
               </EditItemTemplate>
               <InsertItemTemplate>
                  <asp:TextBox ID="txtEmailInsert" runat="server" 
                     Text='<%# Bind("EmailAddress") %>' />
               </InsertItemTemplate>
            </asp:TemplateField>
            <asp:BoundField DataField="Phone" HeaderText="Telefon" SortExpression="Phone" />
            <asp:BoundField DataField="SalesPerson" HeaderText="Przedstawiciel" />
            <asp:BoundField DataField="ModifiedDate" DataFormatString="{0:hh:mm, dd MMM yyyy}" HeaderText="Last Modified" ReadOnly="true" />   
            <asp:BoundField DataField="PasswordHash" HeaderText="Wartość hash" 
               ReadOnly="True" SortExpression="PasswordHash" />
            <asp:BoundField DataField="PasswordSalt" HeaderText="Wartość salt" 
               ReadOnly="True" SortExpression="PasswordSalt" />
            <asp:TemplateField HeaderText="Hasło" Visible="false">
               <InsertItemTemplate>
                  <asp:TextBox ID="txtPasswordInsert" runat="server" />
               </InsertItemTemplate>
            </asp:TemplateField>
            <asp:CommandField ButtonType="Button" ShowEditButton="True" 
               ShowInsertButton="True" />
         </Fields>
      </asp:DetailsView>
   </div>
   </form>
</body>
</html>
