﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="RangeValidator.aspx.cs" Inherits="RangeValidator" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>Zgłaszanie błędów</title>
</head>
<body>
   <h1>
      Zgłaszanie błędów
   </h1>
   <form runat="server" id="frmBugs">
   <table cellpadding="3" border="1">
      <tr>
         <td colspan="3" align="center">
            <asp:Label ID="lblMsg" Text="Proszę poniżej umieścić informacje dotyczące błędu" runat="server" />
         </td>
      </tr>
      <tr>
         <td>
            Książka
         </td>
         <td>
            <asp:DropDownList ID="ddlBooks" runat="server">
               <asp:ListItem>-- Proszę zaznaczyć książkę --</asp:ListItem>
               <asp:ListItem>Programming ASP.NET</asp:ListItem>
               <asp:ListItem>Learning ASP.NET With AJAX</asp:ListItem>
               <asp:ListItem>Programming C# 2008</asp:ListItem>
               <asp:ListItem>Programming Visual Basic 2008</asp:ListItem>
            </asp:DropDownList>
         </td>
         <td>
            <asp:RequiredFieldValidator ID="rfvBooks" ControlToValidate="ddlBooks" Display="Static"
               InitialValue="-- Proszę zaznaczyć książkę --" runat="server" ErrorMessage="Proszę wybrać książkę"
               Text="*" />
         </td>
      </tr>
      <tr>
         <td>
            Edycja:
         </td>
         <td>
            <asp:RadioButtonList ID="rblEdition" RepeatLayout="Flow" runat="server">
               <asp:ListItem>1st</asp:ListItem>
               <asp:ListItem>2nd</asp:ListItem>
               <asp:ListItem>3rd</asp:ListItem>
               <asp:ListItem>4th</asp:ListItem>
            </asp:RadioButtonList>
         </td>
         <td>
            <asp:RequiredFieldValidator ID="rfvEdition" runat="server" ControlToValidate="rblEdition"
               Display="Static" ErrorMessage="Proszę wybrać edycję książki" Text="*" />
         </td>
      </tr>
      <tr>
         <td>
            Błąd:
         </td>
         <td>
            <asp:TextBox ID="txtBug" runat="server" TextMode="MultiLine" />
         </td>
         <td>
            <asp:RequiredFieldValidator ID="rfvBug" ControlToValidate="txtBug" Display="Static"
               runat="server" ErrorMessage="Proszę podać informacje o błędzie" Text="*" />
         </td>
      </tr>
      <tr>
         <td>
            Numer strony:
         </td>
         <td>
            <asp:TextBox ID="txtPageNumber" runat="server" />
         </td>
         <td>
            <asp:RequiredFieldValidator runat="server" ID="rfvPageNumber" ControlToValidate="txtPageNumber"
               ErrorMessage="Nie podano numeru strony" Text="*" />
            <asp:CompareValidator runat="server" ID="cmpPageNumber" ControlToValidate="txtPageNumber"
               ErrorMessage="Nieprawidłowy numer strony" Type="Integer" Operator="DataTypeCheck" Text="*" />
         </td>
      </tr>
      <tr>
         <td>Priorytet:</td>
         <td><asp:TextBox ID="txtPriority" runat="server" /></td>
         <td>
            <asp:RequiredFieldValidator ID="rfvPriority" runat="server" 
               ErrorMessage="Proszę podać priorytet błędu" Text="*"
               ControlToValidate="txtPriority" />
            <asp:RangeValidator ID="rngPriority" runat="server" Text="*" 
               ErrorMessage="Priorytet musi być z zakresu od 1 (wysoki) do 7 (niski)"
               ControlToValidate="txtPriority" Display="Static" Type="Integer"
               MaximumValue="7" MinimumValue="1" />
         </td>
      </tr>
      <tr>
         <td>
            Proszę podać hasło:
         </td>
         <td>
            <asp:TextBox ID="txtPassword1" runat="server" TextMode="Password" />
         </td>
         <td>
            <!-- Wymagane do podania hasła -->
            <asp:RequiredFieldValidator runat="server" ID="rfvPassword1" ControlToValidate="txtPassword1"
               ErrorMessage="Proszę podać hasło" Text="*" />
         </td>
      </tr>
      <!-- Drugie hasło, w celu porównania -->
      <tr>
         <td>
            Proszę ponownie podać hasło:
         </td>
         <td>
            <asp:TextBox ID="txtPassword2" runat="server" TextMode="Password" />
         </td>
         <td>
            <!-- Drugie hasło jest wymagane -->
            <asp:RequiredFieldValidator runat="server" ID="rfvPassword2" ControlToValidate="txtPassword2"
               ErrorMessage="Proszę ponownie podać hasło" Text="*" />
            <!-- Drugie podane hasło musi odpowiadać pierwszemu -->
            <asp:CompareValidator runat="server" ID="cmpPasswords" ControlToValidate="txtPassword2"
               ErrorMessage="Podano różne hasła" Type="String" Operator="Equal" 
               ControlToCompare="txtPassword1" Text="*" />
         </td>
      </tr>
      <tr>
         <td colspan="3" align="center">
            <asp:Button ID="btnSubmit" Text="Zgłoś błąd" runat="server" />
         </td>
      </tr>
   </table>
   <asp:ValidationSummary ID="ValidationSummary1" runat="server" DisplayMode="BulletList"
      HeaderText="Zostały znalezione następujące błędy: " ShowSummary="true" />
   </form>
</body>
</html>
