﻿using System;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class ManageRoles : Page
{
   private string[] rolesArray;
   private string[] usersInRole;
   MembershipUserCollection users;

   protected void Page_Load(object sender, EventArgs e)
   {
      Msg.Text = string.Empty;
      if (!IsPostBack)
      {
         rolesArray = Roles.GetAllRoles();
         RolesListBox.DataSource = rolesArray;
         RolesListBox.DataBind();
         users = Membership.GetAllUsers();
         UsersListBox.DataSource = users;
         UsersListBox.DataBind();
      }
      if (RolesListBox.SelectedItem != null)
      {
         usersInRole = Roles.GetUsersInRole
               (RolesListBox.SelectedItem.Value);
         UsersInRoleGrid.DataSource = usersInRole;
         UsersInRoleGrid.DataBind();
      }
   }

   protected void btnAddUsersToRole_Click(object sender, EventArgs e)
   {
      if (RolesListBox.SelectedItem == null)
      {
         this.Msg.Text = "Proszę wybrać rolę.";
         return;
      }
      if (UsersListBox.SelectedItem == null)
      {
         Msg.Text = "Proszę wybrać jednego lub więcej użytkowników";
         return;
      }

      int sizeOfArray = UsersListBox.GetSelectedIndices().Length;
      string[] newUsers = new string[sizeOfArray];

      // Pobieramy tablicę zaznaczonych indeksów z listy (umożliwia wiele wyborów).
      int[] selectedIndices = UsersListBox.GetSelectedIndices();

      for (int i = 0; i < newUsers.Length; i++)
      {
         // Pobieramy określony zaznaczony selectedIndex odpowiadający counter[i].
         int selectedIndex = selectedIndices[i];
         // Pobieramy ListItem z listy UserListBox i jego offset.
         ListItem myListItem = UsersListBox.Items[selectedIndex];
         // Pobieramy ciąg znakowy, który jest wartością właściwości tego ListItem.
         string newUser = myListItem.Value;
         // Dodajemy ten ciąg znakowy do zbioru ciągów newUsers.
         newUsers[i] = newUser;
      }

      // Dodajemy użytkowników do zaznaczonej roli.
      Roles.AddUsersToRole(newUsers, RolesListBox.SelectedItem.Value);
      usersInRole = Roles.GetUsersInRole(RolesListBox.SelectedItem.Value);
      UsersInRoleGrid.DataSource = usersInRole;
      UsersInRoleGrid.DataBind();
   }

   protected void btnCreateRole_Click(object sender, EventArgs e)
   {
      pnlCreateRole.Visible = true;
   }

   protected void UsersInRoleGrid_RemoveFromRole(object sender, GridViewCommandEventArgs e)
   {
      int index = Convert.ToInt32(e.CommandArgument);
      DataBoundLiteralControl theControl = (DataBoundLiteralControl)(UsersInRoleGrid.Rows[index].Cells[0].Controls[0]);
      string userName = theControl.Text;
      Roles.RemoveUserFromRole(userName, RolesListBox.SelectedItem.Value);
      usersInRole = Roles.GetUsersInRole(RolesListBox.SelectedItem.Value);
      UsersInRoleGrid.DataSource = usersInRole;
      UsersInRoleGrid.DataBind();
   }

   protected void btnAddRole_Click(object sender, EventArgs e)
   {
      if (txtNewRole.Text.Length > 0)
      {
         string newRole = txtNewRole.Text;
         if (Roles.RoleExists(newRole) == false)
         {
            Roles.CreateRole(newRole);
            rolesArray = Roles.GetAllRoles();
            RolesListBox.DataSource = rolesArray;
            RolesListBox.DataBind();
         }
      }
      txtNewRole.Text = string.Empty;
      pnlCreateRole.Visible = false;
   }
}
