﻿using System;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using TestMakerFreeWebApp.ViewModels;
using System.Collections.Generic;
using System.Linq;
using TestMakerFreeWebApp.Data;
using Mapster;

namespace TestMakerFreeWebApp.Controllers
{
   [Route("api/[controller]")]
   public class QuizController : Controller
   {

      #region Pola prywatne
      private ApplicationDbContext DbContext;
      #endregion

      #region Konstruktor
      public QuizController(ApplicationDbContext context)
      {
         // Utworzenie ApplicationDbContext poprzez wstrzykiwanie zależności.
         DbContext = context;
      }
      #endregion

      #region Metody dostosowujące do konwencji REST
      /// <summary>
      /// GET: api/quiz/{}id
      /// Pobiera quiz o podanym {id}
      /// </summary>
      /// <param name="id">Identyfikator istniejącego quizu</param>
      /// <returns>Quiz o podanym {id}</returns>
      [HttpGet("{id}")]
      public IActionResult Get(int id)
      {
         var quiz = DbContext.Quizzes.Where(i => i.Id == id).FirstOrDefault();
         return new JsonResult(
            quiz.Adapt<QuizViewModel>(),
            new JsonSerializerSettings()
            {
               Formatting = Formatting.Indented
            });
      }

      /// <summary>
      /// Dodaje nowy quiz do bazy danych
      /// </summary>
      /// <param name="model">obiekt QuizViewModel z danymi do wstawienia</param>
      [HttpPut]
      public IActionResult Put(QuizViewModel model)
      {
         throw new NotImplementedException();
      }

      /// <summary>
      /// Modyfikuje quiz o podanym {id}
      /// </summary>
      /// <param name="model">obiekt QuizViewModel z danymi do uaktualnienia</param>
      [HttpPost]
      public IActionResult Post(QuizViewModel model)
      {
         throw new NotImplementedException();
      }

      /// <summary>
      /// Usuwa z bazy danych quiz o podanym {id}
      /// </summary>
      /// <param name="id">identyfikator istniejącego quizu</param>
      [HttpDelete("{id}")]
      public IActionResult Delete(int id)
      {
         throw new NotImplementedException();
      }
      #endregion

      #region Metody routingu bazujące na atrybutach
      /// <summary>
      /// GET: api/quiz/latest
      /// Pobiera {num} najnowszych quizów
      /// </summary>
      /// <param name="num">liczba quizów do pobrania</param>
      /// <returns>{num} najnowszych quizów</returns>
      [HttpGet("Latest/{num?}")]
      public IActionResult Latest(int num = 10)
      {
         var latest = DbContext.Quizzes
            .OrderByDescending(q => q.CreatedDate)
            .Take(num)
            .ToArray();
         return new JsonResult(
            latest.Adapt<QuizViewModel[]>(),
            new JsonSerializerSettings()
            {
               Formatting = Formatting.Indented
            });
      }

      /// <summary>
      /// GET: api/quiz/ByTitle
      /// Pobiera {num} quizów posortowanych po tytule (od A do Z)
      /// </summary>
      /// <param name="num">liczba quizów do pobrania</param>
      /// <returns>{num} quizów posortowanych po tytule</returns>
      [HttpGet("ByTitle/{num:int?}")]
      public IActionResult ByTitle(int num = 10)
      {
         var byTitle = DbContext.Quizzes
            .OrderBy(q => q.Title)
            .Take(num)
            .ToArray();
         return new JsonResult(
            byTitle.Adapt<QuizViewModel[]>(),
            new JsonSerializerSettings()
            {
               Formatting = Formatting.Indented
            });
      }

      /// <summary>
      /// GET: api/quiz/mostViewed
      /// Pobiera {num} losowych quizów
      /// </summary>
      /// <param name="num">liczba quizów do pobrania</param>
      /// <returns>{num} losowych quizów</returns>
      [HttpGet("Random/{num:int?}")]
      public IActionResult Random(int num = 10)
      {
         var random = DbContext.Quizzes
            .OrderBy(q => Guid.NewGuid())
            .Take(num)
            .ToArray();
         return new JsonResult(
            random.Adapt<QuizViewModel[]>(),
            new JsonSerializerSettings()
            {
               Formatting = Formatting.Indented
            });
      }
      #endregion
   }
}