﻿using Microsoft.AspNetCore.Identity;
using System;
using System.Collections.Generic;
using System.Linq;

namespace TestMakerFreeWebApp.Data
{
   public static class DataHelper
   {
      /// <summary>
      /// Wygeneruj losowe hasło
      /// spełniające wymagania dotyczące jego siły.
      /// </summary>
      /// <param name="opts">Poprawny obiekt PasswordOptions
      /// zawierający hasło spełniające wymagania siły.</param>
      /// <returns>Losowe hasło</returns>
      public static string GenerateRandomPassword(PasswordOptions opts = null)
      {
         if (opts == null) opts = new PasswordOptions()
         {
            RequiredLength = 7,
            RequiredUniqueChars = 4,
            RequireDigit = true,
            RequireLowercase = true,
            RequireNonAlphanumeric = false,
            RequireUppercase = true
         };

         string[] randomChars = new[] {
        "ABCDEFGHJKLMNOPQRSTUVWXYZ",    // Duże litery 
        "abcdefghijkmnopqrstuvwxyz",    // Małe litery
        "0123456789",                   // Cyfry
        "!@$?_-"                        // Znaki specjalne
    };
         Random rand = new Random(Environment.TickCount);
         List<char> chars = new List<char>();

         if (opts.RequireUppercase)
            chars.Insert(rand.Next(0, chars.Count),
                randomChars[0][rand.Next(0, randomChars[0].Length)]);

         if (opts.RequireLowercase)
            chars.Insert(rand.Next(0, chars.Count),
                randomChars[1][rand.Next(0, randomChars[1].Length)]);

         if (opts.RequireDigit)
            chars.Insert(rand.Next(0, chars.Count),
                randomChars[2][rand.Next(0, randomChars[2].Length)]);

         if (opts.RequireNonAlphanumeric)
            chars.Insert(rand.Next(0, chars.Count),
                randomChars[3][rand.Next(0, randomChars[3].Length)]);

         for (int i = chars.Count; i < opts.RequiredLength
             || chars.Distinct().Count() < opts.RequiredUniqueChars; i++)
         {
            string rcs = randomChars[rand.Next(0, randomChars.Length)];
            chars.Insert(rand.Next(0, chars.Count),
                rcs[rand.Next(0, rcs.Length)]);
         }

         return new string(chars.ToArray());
      }
   }
}

