import { EventEmitter, Inject, Injectable, PLATFORM_ID } from "@angular/core";
import { isPlatformBrowser } from '@angular/common';
import { HttpClient, HttpHeaders } from "@angular/common/http";
import { Observable } from "rxjs";
import 'rxjs/Rx';

@Injectable()
export class AuthService {
   authKey: string = "auth";
   clientId: string = "TestMakerFree";

   constructor(private http: HttpClient,
      @Inject(PLATFORM_ID) private platformId: any) {
   }

   // Przeprowad logowanie
   login(username: string, password: string): Observable<boolean> {
      var url = "api/token/auth";
      var data = {
         username: username,
         password: password,
         client_id: this.clientId,
         // Wymagane do zalogowania si przy uyciu nazwy uytkownika i hasa
         grant_type: "password",
         // Oddzielona spacjami lista zakresw, dla ktrych token bdzie wany
         scope: "offline_access profile email"
      };

      return this.getAuthFromServer(url, data);
   }

   // Sprbuj odwiey token
   refreshToken(): Observable<boolean> {
      var url = "api/token/auth";
      var data = {
         client_id: this.clientId,
         // Wymagane do zalogowania si przy uyciu nazwy uytkownika i hasa
         grant_type: "refresh_token",
         refresh_token: this.getAuth()!.refresh_token,
         // Oddzielona spacjami lista zakresw, dla ktrych token bdzie wany
         scope: "offline_access profile email"
      };

      return this.getAuthFromServer(url, data);
   }

   // Pobierz z serwera tokeny (dostpowy i odwieania)
   getAuthFromServer(url: string, data: any): Observable<boolean> {
      return this.http.post<TokenResponse>(url, data)
         .map((res) => {
            let token = res && res.token;
            // Jeli jest token, logowanie si udao
            if (token) {
               // Zapamitaj nazw uytkownika i tokeny
               this.setAuth(res);
               // Logowanie udane
               return true;
            }

            // Logowanie nieudane
            return Observable.throw('Unauthorized');
         })
         .catch(error => {
            return new Observable<any>(error);
         });
   }


   // Przeprowad wylogowanie
   logout(): boolean {
      this.setAuth(null);
      return true;
   }

   // Umie dane o uwierzytelnieniu w localStorage lub usu dane, jeli przekazano NULL
   setAuth(auth: TokenResponse | null): boolean {
      if (auth) {
         localStorage.setItem(
            this.authKey,
            JSON.stringify(auth));
      }
      else {
         localStorage.removeItem(this.authKey);
      }
      return true;
   }

   // Pobiera obiekt z danymi uwierzytelnienia (lub zwraca NULL, jeli nie istnieje)
   getAuth(): TokenResponse | null {
      var i = localStorage.getItem(this.authKey);
      if (i) {
         return JSON.parse(i);
      }
      else {
         return null;
      }
   }

   // Zwraca TRUE, jeli uytkownik jest zalogowany lub FALSE w sytuacji przeciwnej
   isLoggedIn(): boolean {
      return localStorage.getItem(this.authKey) != null;
   }
} 
